/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.support;

import java.util.ArrayList;
import javax.sql.DataSource;
import org.springframework.batch.item.database.support.DataFieldMaxValueIncrementerFactory;
import org.springframework.batch.item.database.support.SqliteMaxValueIncrementer;
import org.springframework.batch.support.DatabaseType;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.Db2LuwMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.Db2MainframeMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.DerbyMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.H2SequenceMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.HanaSequenceMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.HsqlMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.MariaDBSequenceMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.MySQLMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.OracleSequenceMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.PostgresSequenceMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.SqlServerSequenceMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.SybaseMaxValueIncrementer;

public class DefaultDataFieldMaxValueIncrementerFactory
implements DataFieldMaxValueIncrementerFactory {
    private final DataSource dataSource;
    private String incrementerColumnName = "ID";

    public void setIncrementerColumnName(String incrementerColumnName) {
        this.incrementerColumnName = incrementerColumnName;
    }

    public DefaultDataFieldMaxValueIncrementerFactory(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public DataFieldMaxValueIncrementer getIncrementer(String incrementerType, String incrementerName) {
        DatabaseType databaseType = DatabaseType.valueOf(incrementerType.toUpperCase());
        if (databaseType == DatabaseType.DB2 || databaseType == DatabaseType.DB2AS400) {
            return new Db2LuwMaxValueIncrementer(this.dataSource, incrementerName);
        }
        if (databaseType == DatabaseType.DB2ZOS) {
            return new Db2MainframeMaxValueIncrementer(this.dataSource, incrementerName);
        }
        if (databaseType == DatabaseType.DERBY) {
            return new DerbyMaxValueIncrementer(this.dataSource, incrementerName, this.incrementerColumnName);
        }
        if (databaseType == DatabaseType.HSQL) {
            return new HsqlMaxValueIncrementer(this.dataSource, incrementerName, this.incrementerColumnName);
        }
        if (databaseType == DatabaseType.H2) {
            return new H2SequenceMaxValueIncrementer(this.dataSource, incrementerName);
        }
        if (databaseType == DatabaseType.HANA) {
            return new HanaSequenceMaxValueIncrementer(this.dataSource, incrementerName);
        }
        if (databaseType == DatabaseType.MYSQL) {
            MySQLMaxValueIncrementer mySQLMaxValueIncrementer = new MySQLMaxValueIncrementer(this.dataSource, incrementerName, this.incrementerColumnName);
            mySQLMaxValueIncrementer.setUseNewConnection(true);
            return mySQLMaxValueIncrementer;
        }
        if (databaseType == DatabaseType.MARIADB) {
            return new MariaDBSequenceMaxValueIncrementer(this.dataSource, incrementerName);
        }
        if (databaseType == DatabaseType.ORACLE) {
            return new OracleSequenceMaxValueIncrementer(this.dataSource, incrementerName);
        }
        if (databaseType == DatabaseType.POSTGRES) {
            return new PostgresSequenceMaxValueIncrementer(this.dataSource, incrementerName);
        }
        if (databaseType == DatabaseType.SQLITE) {
            return new SqliteMaxValueIncrementer(this.dataSource, incrementerName, this.incrementerColumnName);
        }
        if (databaseType == DatabaseType.SQLSERVER) {
            return new SqlServerSequenceMaxValueIncrementer(this.dataSource, incrementerName);
        }
        if (databaseType == DatabaseType.SYBASE) {
            return new SybaseMaxValueIncrementer(this.dataSource, incrementerName, this.incrementerColumnName);
        }
        throw new IllegalArgumentException("databaseType argument was not on the approved list");
    }

    @Override
    public boolean isSupportedIncrementerType(String incrementerType) {
        for (DatabaseType type : DatabaseType.values()) {
            if (!type.name().equalsIgnoreCase(incrementerType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getSupportedIncrementerTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (DatabaseType type : DatabaseType.values()) {
            types.add(type.name());
        }
        return types.toArray(new String[types.size()]);
    }
}

