/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import org.springframework.beans.PropertyValues;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.web.ConditionalOnEnabledResourceChain;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.bind.PropertySourcesPropertyValues;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySources;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ClassUtils;

class OnEnabledResourceChainCondition
extends SpringBootCondition {
    private static final String WEBJAR_ASSET_LOCATOR = "org.webjars.WebJarAssetLocator";

    OnEnabledResourceChainCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConfigurableEnvironment environment = (ConfigurableEnvironment)context.getEnvironment();
        ResourceProperties properties = new ResourceProperties();
        RelaxedDataBinder binder = new RelaxedDataBinder((Object)properties, "spring.resources");
        binder.bind((PropertyValues)new PropertySourcesPropertyValues((PropertySources)environment.getPropertySources()));
        Boolean match = properties.getChain().getEnabled();
        ConditionMessage.Builder message = ConditionMessage.forCondition(ConditionalOnEnabledResourceChain.class, new Object[0]);
        if (match == null) {
            if (ClassUtils.isPresent((String)WEBJAR_ASSET_LOCATOR, (ClassLoader)this.getClass().getClassLoader())) {
                return ConditionOutcome.match(message.found("class").items(WEBJAR_ASSET_LOCATOR));
            }
            return ConditionOutcome.noMatch(message.didNotFind("class").items(WEBJAR_ASSET_LOCATOR));
        }
        if (match.booleanValue()) {
            return ConditionOutcome.match(message.because("enabled"));
        }
        return ConditionOutcome.noMatch(message.because("disabled"));
    }
}

