/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.redis.health;

import org.springframework.boot.data.redis.health.DataRedisHealth;
import org.springframework.boot.health.contributor.AbstractHealthIndicator;
import org.springframework.boot.health.contributor.Health;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.util.Assert;

public class DataRedisHealthIndicator
extends AbstractHealthIndicator {
    private final RedisConnectionFactory redisConnectionFactory;

    public DataRedisHealthIndicator(RedisConnectionFactory connectionFactory) {
        super("Redis health check failed");
        Assert.notNull((Object)connectionFactory, (String)"'connectionFactory' must not be null");
        this.redisConnectionFactory = connectionFactory;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        RedisConnection connection = RedisConnectionUtils.getConnection((RedisConnectionFactory)this.redisConnectionFactory);
        try {
            this.doHealthCheck(builder, connection);
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisConnectionFactory);
        }
    }

    private void doHealthCheck(Health.Builder builder, RedisConnection connection) {
        if (connection instanceof RedisClusterConnection) {
            RedisClusterConnection clusterConnection = (RedisClusterConnection)connection;
            DataRedisHealth.fromClusterInfo(builder, clusterConnection.clusterGetClusterInfo());
        } else {
            DataRedisHealth.up(builder, connection.serverCommands().info());
        }
    }
}

