/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.hibernate.autoconfigure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.annotations.EmbeddedTable;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.model.naming.PhysicalNamingStrategySnakeCaseImpl;
import org.hibernate.boot.models.annotations.internal.EmbeddedTableAnnotation;
import org.hibernate.event.spi.PreFlushEventListener;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeHint;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.hibernate.SpringImplicitNamingStrategy;
import org.springframework.boot.hibernate.SpringJtaPlatform;
import org.springframework.boot.hibernate.autoconfigure.HibernateDefaultDdlAutoProvider;
import org.springframework.boot.hibernate.autoconfigure.HibernateProperties;
import org.springframework.boot.hibernate.autoconfigure.HibernatePropertiesCustomizer;
import org.springframework.boot.hibernate.autoconfigure.HibernateSettings;
import org.springframework.boot.jdbc.SchemaManagementProvider;
import org.springframework.boot.jdbc.metadata.CompositeDataSourcePoolMetadataProvider;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadata;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.boot.jpa.autoconfigure.JpaBaseConfiguration;
import org.springframework.boot.jpa.autoconfigure.JpaProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jndi.JndiLocatorDelegate;
import org.springframework.orm.jpa.hibernate.SpringBeanContainer;
import org.springframework.orm.jpa.vendor.AbstractJpaVendorAdapter;
import org.springframework.orm.jpa.vendor.HibernateJpaDialect;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.ClassUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={HibernateProperties.class})
@ConditionalOnSingleCandidate(value=DataSource.class)
@ImportRuntimeHints(value={HibernateRuntimeHints.class, Hibernate72RuntimeHints.class})
class HibernateJpaConfiguration
extends JpaBaseConfiguration {
    private static final Log logger = LogFactory.getLog(HibernateJpaConfiguration.class);
    private static final String JTA_PLATFORM = "hibernate.transaction.jta.platform";
    private static final String PROVIDER_DISABLES_AUTOCOMMIT = "hibernate.connection.provider_disables_autocommit";
    private static final String[] NO_JTA_PLATFORM_CLASSES = new String[]{"org.hibernate.engine.transaction.jta.platform.internal.NoJtaPlatform", "org.hibernate.service.jta.platform.internal.NoJtaPlatform"};
    private final HibernateProperties hibernateProperties;
    private final HibernateDefaultDdlAutoProvider defaultDdlAutoProvider;
    private final DataSourcePoolMetadataProvider poolMetadataProvider;
    private final ObjectProvider<SQLExceptionTranslator> sqlExceptionTranslator;
    private final List<HibernatePropertiesCustomizer> hibernatePropertiesCustomizers;

    HibernateJpaConfiguration(DataSource dataSource, JpaProperties jpaProperties, ConfigurableListableBeanFactory beanFactory, ObjectProvider<JtaTransactionManager> jtaTransactionManager, HibernateProperties hibernateProperties, ObjectProvider<Collection<DataSourcePoolMetadataProvider>> metadataProviders, ObjectProvider<SchemaManagementProvider> providers, ObjectProvider<PhysicalNamingStrategy> physicalNamingStrategy, ObjectProvider<ImplicitNamingStrategy> implicitNamingStrategy, ObjectProvider<SQLExceptionTranslator> sqlExceptionTranslator, ObjectProvider<HibernatePropertiesCustomizer> hibernatePropertiesCustomizers) {
        super(dataSource, jpaProperties, jtaTransactionManager);
        this.hibernateProperties = hibernateProperties;
        this.defaultDdlAutoProvider = new HibernateDefaultDdlAutoProvider((Iterable<SchemaManagementProvider>)providers);
        this.poolMetadataProvider = new CompositeDataSourcePoolMetadataProvider((Collection)metadataProviders.getIfAvailable());
        this.sqlExceptionTranslator = sqlExceptionTranslator;
        this.hibernatePropertiesCustomizers = this.determineHibernatePropertiesCustomizers((PhysicalNamingStrategy)physicalNamingStrategy.getIfAvailable(), (ImplicitNamingStrategy)implicitNamingStrategy.getIfAvailable(), beanFactory, hibernatePropertiesCustomizers.orderedStream().toList());
    }

    private List<HibernatePropertiesCustomizer> determineHibernatePropertiesCustomizers(@Nullable PhysicalNamingStrategy physicalNamingStrategy, @Nullable ImplicitNamingStrategy implicitNamingStrategy, ConfigurableListableBeanFactory beanFactory, List<HibernatePropertiesCustomizer> hibernatePropertiesCustomizers) {
        ArrayList<HibernatePropertiesCustomizer> customizers = new ArrayList<HibernatePropertiesCustomizer>();
        if (ClassUtils.isPresent((String)"org.hibernate.resource.beans.container.spi.BeanContainer", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader())) {
            customizers.add(properties -> properties.put("hibernate.resource.beans.container", new SpringBeanContainer(beanFactory)));
        }
        if (physicalNamingStrategy != null || implicitNamingStrategy != null) {
            customizers.add(new NamingStrategiesHibernatePropertiesCustomizer(physicalNamingStrategy, implicitNamingStrategy));
        }
        customizers.addAll(hibernatePropertiesCustomizers);
        return customizers;
    }

    protected AbstractJpaVendorAdapter createJpaVendorAdapter() {
        HibernateJpaVendorAdapter adapter = new HibernateJpaVendorAdapter();
        this.sqlExceptionTranslator.ifUnique(arg_0 -> ((HibernateJpaDialect)adapter.getJpaDialect()).setJdbcExceptionTranslator(arg_0));
        return adapter;
    }

    protected Map<String, Object> getVendorProperties(DataSource dataSource) {
        Supplier<String> defaultDdlMode = () -> this.defaultDdlAutoProvider.getDefaultDdlAuto(dataSource);
        return new LinkedHashMap<String, Object>(this.hibernateProperties.determineHibernateProperties(this.getProperties().getProperties(), new HibernateSettings().ddlAuto(defaultDdlMode).hibernatePropertiesCustomizers(this.hibernatePropertiesCustomizers)));
    }

    protected void customizeVendorProperties(Map<String, Object> vendorProperties) {
        super.customizeVendorProperties(vendorProperties);
        if (!vendorProperties.containsKey(JTA_PLATFORM)) {
            this.configureJtaPlatform(vendorProperties);
        }
        if (!vendorProperties.containsKey(PROVIDER_DISABLES_AUTOCOMMIT)) {
            this.configureProviderDisablesAutocommit(vendorProperties);
        }
    }

    private void configureJtaPlatform(Map<String, Object> vendorProperties) throws LinkageError {
        JtaTransactionManager jtaTransactionManager = this.getJtaTransactionManager();
        if (jtaTransactionManager == null) {
            vendorProperties.put(JTA_PLATFORM, this.getNoJtaPlatformManager());
        } else if (!this.runningOnWebSphere()) {
            this.configureSpringJtaPlatform(vendorProperties, jtaTransactionManager);
        }
    }

    private void configureProviderDisablesAutocommit(Map<String, Object> vendorProperties) {
        if (this.isDataSourceAutoCommitDisabled() && !this.isJta()) {
            vendorProperties.put(PROVIDER_DISABLES_AUTOCOMMIT, "true");
        }
    }

    private boolean isDataSourceAutoCommitDisabled() {
        DataSourcePoolMetadata poolMetadata = this.poolMetadataProvider.getDataSourcePoolMetadata(this.getDataSource());
        return poolMetadata != null && Boolean.FALSE.equals(poolMetadata.getDefaultAutoCommit());
    }

    private boolean runningOnWebSphere() {
        return ClassUtils.isPresent((String)"com.ibm.websphere.jtaextensions.ExtendedJTATransaction", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
    }

    private void configureSpringJtaPlatform(Map<String, Object> vendorProperties, JtaTransactionManager jtaTransactionManager) {
        block3: {
            try {
                vendorProperties.put(JTA_PLATFORM, (Object)new SpringJtaPlatform(jtaTransactionManager));
            }
            catch (LinkageError ex) {
                if (!this.isUsingJndi()) {
                    throw new IllegalStateException("Unable to set Hibernate JTA platform, are you using the correct version of Hibernate?", ex);
                }
                if (!logger.isDebugEnabled()) break block3;
                logger.debug((Object)("Unable to set Hibernate JTA platform : " + ex.getMessage()));
            }
        }
    }

    private boolean isUsingJndi() {
        try {
            return JndiLocatorDelegate.isDefaultJndiEnvironmentAvailable();
        }
        catch (Error ex) {
            return false;
        }
    }

    private Object getNoJtaPlatformManager() {
        for (String candidate : NO_JTA_PLATFORM_CLASSES) {
            try {
                return Class.forName(candidate).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
            }
        }
        throw new IllegalStateException("No available JtaPlatform candidates amongst " + Arrays.toString(NO_JTA_PLATFORM_CLASSES));
    }

    private static class NamingStrategiesHibernatePropertiesCustomizer
    implements HibernatePropertiesCustomizer {
        private final @Nullable PhysicalNamingStrategy physicalNamingStrategy;
        private final @Nullable ImplicitNamingStrategy implicitNamingStrategy;

        NamingStrategiesHibernatePropertiesCustomizer(@Nullable PhysicalNamingStrategy physicalNamingStrategy, @Nullable ImplicitNamingStrategy implicitNamingStrategy) {
            this.physicalNamingStrategy = physicalNamingStrategy;
            this.implicitNamingStrategy = implicitNamingStrategy;
        }

        @Override
        public void customize(Map<String, Object> hibernateProperties) {
            if (this.physicalNamingStrategy != null) {
                hibernateProperties.put("hibernate.physical_naming_strategy", this.physicalNamingStrategy);
            }
            if (this.implicitNamingStrategy != null) {
                hibernateProperties.put("hibernate.implicit_naming_strategy", this.implicitNamingStrategy);
            }
        }
    }

    static class Hibernate72RuntimeHints
    implements RuntimeHintsRegistrar {
        Hibernate72RuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
            this.registerLoggerHints(hints.reflection());
            this.registerEventHints(hints.reflection());
            this.registerAnnotationHints(hints.reflection());
        }

        private void registerLoggerHints(ReflectionHints reflection) {
            reflection.registerTypes(Set.of(TypeReference.of((String)"org.hibernate.action.internal.ActionLogging_$logger"), TypeReference.of((String)"org.hibernate.boot.BootLogging_$logger"), TypeReference.of((String)"org.hibernate.boot.beanvalidation.BeanValidationLogger_$logger"), TypeReference.of((String)"org.hibernate.bytecode.enhance.spi.interceptor.BytecodeInterceptorLogging_$logger"), TypeReference.of((String)"org.hibernate.collection.internal.CollectionLogger_$logger"), TypeReference.of((String)"org.hibernate.context.internal.CurrentSessionLogging_$logger"), TypeReference.of((String)"org.hibernate.engine.internal.NaturalIdLogging_$logger"), TypeReference.of((String)"org.hibernate.engine.internal.PersistenceContextLogging_$logger"), TypeReference.of((String)"org.hibernate.engine.internal.SessionMetricsLogger_$logger"), TypeReference.of((String)"org.hibernate.engine.jdbc.JdbcLogging_$logger"), TypeReference.of((String)"org.hibernate.engine.jdbc.batch.JdbcBatchLogging_$logger"), TypeReference.of((String)"org.hibernate.engine.jdbc.connections.internal.ConnectionProviderLogging_$logger"), TypeReference.of((String)"org.hibernate.engine.jdbc.env.internal.LobCreationLogging_$logger"), TypeReference.of((String)"org.hibernate.engine.jdbc.spi.SQLExceptionLogging_$logger"), TypeReference.of((String)"org.hibernate.event.internal.EntityCopyLogging_$logger"), TypeReference.of((String)"org.hibernate.event.internal.EventListenerLogging_$logger"), TypeReference.of((String)"org.hibernate.id.UUIDLogger_$logger"), TypeReference.of((String)"org.hibernate.id.enhanced.OptimizerLogger_$logger"), TypeReference.of((String)"org.hibernate.internal.SessionFactoryLogging_$logger"), TypeReference.of((String)"org.hibernate.internal.SessionLogging_$logger"), TypeReference.of((String)"org.hibernate.internal.log.StatisticsLogger_$logger"), TypeReference.of((String)"org.hibernate.jpa.internal.JpaLogger_$logger"), TypeReference.of((String)"org.hibernate.loader.ast.internal.MultiKeyLoadLogging_$logger"), TypeReference.of((String)"org.hibernate.metamodel.mapping.MappingModelCreationLogging_$logger"), TypeReference.of((String)"org.hibernate.query.QueryLogging_$logger"), TypeReference.of((String)"org.hibernate.query.hql.HqlLogging_$logger"), TypeReference.of((String)"org.hibernate.resource.jdbc.internal.LogicalConnectionLogging_$logger"), TypeReference.of((String)"org.hibernate.resource.transaction.backend.jta.internal.JtaLogging_$logger"), TypeReference.of((String)"org.hibernate.resource.transaction.internal.SynchronizationLogging_$logger"), TypeReference.of((String)"org.hibernate.service.internal.ServiceLogger_$logger"), TypeReference.of((String)"org.hibernate.sql.model.ModelMutationLogging_$logger"), TypeReference.of((String)"org.hibernate.sql.results.graph.embeddable.EmbeddableLoadingLogger_$logger")), hint -> hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS}));
        }

        private void registerEventHints(ReflectionHints reflection) {
            reflection.registerType(PreFlushEventListener.class, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS});
            reflection.registerType(PreFlushEventListener[].class, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS});
        }

        private void registerAnnotationHints(ReflectionHints reflection) {
            reflection.registerType(EmbeddedTable.class, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS});
            reflection.registerType(EmbeddedTableAnnotation.class, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS});
        }
    }

    static class HibernateRuntimeHints
    implements RuntimeHintsRegistrar {
        private static final Consumer<TypeHint.Builder> INVOKE_DECLARED_CONSTRUCTORS = TypeHint.builtWith((MemberCategory[])new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});

        HibernateRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
            for (String noJtaPlatformClass : NO_JTA_PLATFORM_CLASSES) {
                hints.reflection().registerType(TypeReference.of((String)noJtaPlatformClass), INVOKE_DECLARED_CONSTRUCTORS);
            }
            hints.reflection().registerType(SpringImplicitNamingStrategy.class, INVOKE_DECLARED_CONSTRUCTORS);
            hints.reflection().registerType(PhysicalNamingStrategySnakeCaseImpl.class, INVOKE_DECLARED_CONSTRUCTORS);
        }
    }
}

