/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.kafka.autoconfigure.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.kafka.KafkaClientMetrics;
import io.micrometer.core.instrument.binder.kafka.KafkaStreamsMetrics;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.kafka.autoconfigure.DefaultKafkaConsumerFactoryCustomizer;
import org.springframework.boot.kafka.autoconfigure.DefaultKafkaProducerFactoryCustomizer;
import org.springframework.boot.kafka.autoconfigure.KafkaAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.config.StreamsBuilderFactoryBean;
import org.springframework.kafka.config.StreamsBuilderFactoryBeanConfigurer;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.MicrometerConsumerListener;
import org.springframework.kafka.core.MicrometerProducerListener;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.streams.KafkaStreamsMicrometerListener;

@AutoConfiguration(before={KafkaAutoConfiguration.class}, afterName={"org.springframework.boot.micrometer.metrics.autoconfigure.MetricsAutoConfiguration", "org.springframework.boot.micrometer.metrics.autoconfigure.CompositeMeterRegistryAutoConfiguration"})
@ConditionalOnClass(value={KafkaClientMetrics.class, ProducerFactory.class, MeterRegistry.class})
@ConditionalOnBean(value={MeterRegistry.class})
public final class KafkaMetricsAutoConfiguration {
    @Bean
    DefaultKafkaProducerFactoryCustomizer kafkaProducerMetrics(MeterRegistry meterRegistry) {
        return producerFactory -> this.addListener(producerFactory, meterRegistry);
    }

    @Bean
    DefaultKafkaConsumerFactoryCustomizer kafkaConsumerMetrics(MeterRegistry meterRegistry) {
        return consumerFactory -> this.addListener(consumerFactory, meterRegistry);
    }

    private <K, V> void addListener(DefaultKafkaConsumerFactory<K, V> factory, MeterRegistry meterRegistry) {
        factory.addListener((ConsumerFactory.Listener)new MicrometerConsumerListener(meterRegistry));
    }

    private <K, V> void addListener(DefaultKafkaProducerFactory<K, V> factory, MeterRegistry meterRegistry) {
        factory.addListener((ProducerFactory.Listener)new MicrometerProducerListener(meterRegistry));
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={KafkaStreamsMetrics.class, StreamsBuilderFactoryBean.class})
    static class KafkaStreamsMetricsConfiguration {
        KafkaStreamsMetricsConfiguration() {
        }

        @Bean
        StreamsBuilderFactoryBeanConfigurer kafkaStreamsMetrics(MeterRegistry meterRegistry) {
            return factoryBean -> factoryBean.addListener((StreamsBuilderFactoryBean.Listener)new KafkaStreamsMicrometerListener(meterRegistry));
        }
    }
}

