/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection.pulsar;

import org.springframework.boot.autoconfigure.pulsar.PulsarConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.PulsarContainer;

class PulsarContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<PulsarContainer, PulsarConnectionDetails> {
    PulsarContainerConnectionDetailsFactory() {
    }

    @Override
    protected PulsarConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<PulsarContainer> source) {
        return new PulsarContainerConnectionDetails(source);
    }

    private static final class PulsarContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<PulsarContainer>
    implements PulsarConnectionDetails {
        private PulsarContainerConnectionDetails(ContainerConnectionSource<PulsarContainer> source) {
            super(source);
        }

        public String getBrokerUrl() {
            return ((PulsarContainer)this.getContainer()).getPulsarBrokerUrl();
        }

        public String getAdminUrl() {
            return ((PulsarContainer)this.getContainer()).getHttpServiceUrl();
        }
    }
}

