/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.simple;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.cloud.client.discovery.simple.InstanceProperties;
import org.springframework.core.style.ToStringCreator;

@ConfigurationProperties(prefix="spring.cloud.discovery.client.simple")
public class SimpleDiscoveryProperties
implements InitializingBean {
    private Map<String, List<InstanceProperties>> instances = new HashMap<String, List<InstanceProperties>>();
    @NestedConfigurationProperty
    private InstanceProperties local = new InstanceProperties();
    private int order = 0;

    public Map<String, List<InstanceProperties>> getInstances() {
        return this.instances;
    }

    public void setInstances(Map<String, List<InstanceProperties>> instances) {
        this.instances = instances;
    }

    public InstanceProperties getLocal() {
        return this.local;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void afterPropertiesSet() {
        for (String key : this.instances.keySet()) {
            for (InstanceProperties instance : this.instances.get(key)) {
                instance.setServiceId(key);
            }
        }
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("instances", this.instances).append("local", (Object)this.local).append("order", this.order).toString();
    }
}

