/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.retry.annotation.Retryable;

public class ConfigServerInstanceProvider {
    private Log log = LogFactory.getLog(this.getClass());
    private final Function function;
    private BindHandler bindHandler;
    private Binder binder;

    public ConfigServerInstanceProvider(Function function) {
        this.function = function;
    }

    public ConfigServerInstanceProvider(Function function, Binder binder, BindHandler bindHandler) {
        this.function = function;
        this.binder = binder;
        this.bindHandler = bindHandler;
    }

    void setLog(Log log) {
        this.log = log;
    }

    @Retryable(interceptor="configServerRetryInterceptor")
    public List<ServiceInstance> getConfigServerInstances(String serviceId) {
        List<ServiceInstance> instances;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Locating configserver (" + serviceId + ") via discovery"));
        }
        if ((instances = this.binder == null || this.bindHandler == null ? this.function.apply(serviceId) : this.function.apply(serviceId, this.binder, this.bindHandler, this.log)).isEmpty()) {
            throw new IllegalStateException("No instances found of configserver (" + serviceId + ")");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Located configserver (" + serviceId + ") via discovery. No of instances found: " + instances.size()));
        }
        return instances;
    }

    @FunctionalInterface
    public static interface Function {
        public List<ServiceInstance> apply(String var1);

        default public List<ServiceInstance> apply(String serviceId, Binder binder, BindHandler bindHandler, Log log) {
            return this.apply(serviceId);
        }
    }
}

