/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.resource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletRequest;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.resource.NoSuchResourceException;
import org.springframework.cloud.config.server.resource.ResourceRepository;
import org.springframework.cloud.config.server.support.EnvironmentPropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.http.HttpStatus;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UrlPathHelper;

@RestController
@RequestMapping(method={RequestMethod.GET}, path={"${spring.cloud.config.server.prefix:}"})
public class ResourceController {
    private ResourceRepository resourceRepository;
    private EnvironmentRepository environmentRepository;
    private UrlPathHelper helper = new UrlPathHelper();

    public ResourceController(ResourceRepository resourceRepository, EnvironmentRepository environmentRepository) {
        this.resourceRepository = resourceRepository;
        this.environmentRepository = environmentRepository;
        this.helper.setAlwaysUseFullPath(true);
    }

    @RequestMapping(value={"/{name}/{profile}/{label}/**"})
    public String resolve(@PathVariable String name, @PathVariable String profile, @PathVariable String label, HttpServletRequest request) throws IOException {
        String path = this.getFilePath(request, name, profile, label);
        return this.resolve(name, profile, label, path);
    }

    private String getFilePath(HttpServletRequest request, String name, String profile, String label) {
        String stem = String.format("/%s/%s/%s/", name, profile, label);
        String path = this.helper.getPathWithinApplication(request);
        path = path.substring(path.indexOf(stem) + stem.length());
        return path;
    }

    synchronized String resolve(String name, String profile, String label, String path) throws IOException {
        if (label != null && label.contains("(_)")) {
            label = label.replace("(_)", "/");
        }
        StandardEnvironment environment = EnvironmentPropertySource.prepareEnvironment(this.environmentRepository.findOne(name, profile, label));
        try (InputStream is = this.resourceRepository.findOne(name, profile, label, path).getInputStream();){
            String text = StreamUtils.copyToString((InputStream)is, (Charset)Charset.forName("UTF-8"));
            String string = EnvironmentPropertySource.resolvePlaceholders(environment, text);
            return string;
        }
    }

    @RequestMapping(value={"/{name}/{profile}/{label}/**"}, produces={"application/octet-stream"})
    public synchronized byte[] binary(@PathVariable String name, @PathVariable String profile, @PathVariable String label, HttpServletRequest request) throws IOException {
        String path = this.getFilePath(request, name, profile, label);
        return this.binary(name, profile, label, path);
    }

    synchronized byte[] binary(String name, String profile, String label, String path) throws IOException {
        if (label != null && label.contains("(_)")) {
            label = label.replace("(_)", "/");
        }
        EnvironmentPropertySource.prepareEnvironment(this.environmentRepository.findOne(name, profile, label));
        try (InputStream is = this.resourceRepository.findOne(name, profile, label, path).getInputStream();){
            byte[] byArray = StreamUtils.copyToByteArray((InputStream)is);
            return byArray;
        }
    }

    @ExceptionHandler(value={NoSuchResourceException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public void notFound(NoSuchResourceException e) {
    }
}

