/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.logging.LogFile;
import org.springframework.boot.logging.LoggingInitializationContext;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.cloud.bootstrap.config.BootstrapPropertySource;
import org.springframework.cloud.bootstrap.config.PropertySourceBootstrapProperties;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.bootstrap.config.SimpleBootstrapPropertySource;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.logging.LoggingRebinder;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={PropertySourceBootstrapProperties.class})
public class PropertySourceBootstrapConfiguration
implements ApplicationListener<ContextRefreshedEvent>,
ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    public static final String BOOTSTRAP_PROPERTY_SOURCE_NAME = "bootstrapProperties";
    private static Log logger = LogFactory.getLog(PropertySourceBootstrapConfiguration.class);
    private int order = -2147483638;
    @Autowired(required=false)
    private List<PropertySourceLocator> propertySourceLocators = new ArrayList<PropertySourceLocator>();
    @Autowired
    private PropertySourceBootstrapProperties bootstrapProperties;

    public int getOrder() {
        return this.order;
    }

    public void setPropertySourceLocators(Collection<PropertySourceLocator> propertySourceLocators) {
        this.propertySourceLocators = new ArrayList<PropertySourceLocator>(propertySourceLocators);
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        if (!this.bootstrapProperties.isInitializeOnContextRefresh() || !applicationContext.getEnvironment().getPropertySources().contains("bootstrap")) {
            this.doInitialize(applicationContext);
        }
    }

    private void doInitialize(ConfigurableApplicationContext applicationContext) {
        ArrayList composite = new ArrayList();
        AnnotationAwareOrderComparator.sort(this.propertySourceLocators);
        boolean empty = true;
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        for (PropertySourceLocator locator : this.propertySourceLocators) {
            Collection<PropertySource<?>> source = locator.locateCollection((Environment)environment);
            if (source == null || source.size() == 0) continue;
            ArrayList<Object> sourceList = new ArrayList<Object>();
            for (PropertySource<?> p : source) {
                if (p instanceof EnumerablePropertySource) {
                    EnumerablePropertySource enumerable = (EnumerablePropertySource)p;
                    sourceList.add((Object)new BootstrapPropertySource(enumerable));
                    continue;
                }
                sourceList.add((Object)new SimpleBootstrapPropertySource(p));
            }
            logger.info((Object)("Located property source: " + String.valueOf(sourceList)));
            composite.addAll(sourceList);
            empty = false;
        }
        if (!empty) {
            MutablePropertySources propertySources = environment.getPropertySources();
            String logConfig = environment.resolvePlaceholders("${logging.config:}");
            LogFile logFile = LogFile.get((PropertyResolver)environment);
            for (PropertySource p : environment.getPropertySources()) {
                if (!p.getName().startsWith(BOOTSTRAP_PROPERTY_SOURCE_NAME)) continue;
                propertySources.remove(p.getName());
            }
            this.insertPropertySources(propertySources, composite);
            this.reinitializeLoggingSystem(environment);
            this.setLogLevels(applicationContext, environment);
            this.handleProfiles(environment);
        }
    }

    private void reinitializeLoggingSystem(ConfigurableEnvironment environment) {
        Map props = (Map)Binder.get((Environment)environment).bind("logging", Bindable.mapOf(String.class, Object.class)).orElseGet(Collections::emptyMap);
        if (!props.isEmpty()) {
            String logConfig = environment.resolvePlaceholders("${logging.config:}");
            LogFile logFile = LogFile.get((PropertyResolver)environment);
            LoggingSystem system = LoggingSystem.get((ClassLoader)LoggingSystem.class.getClassLoader());
            try {
                system.cleanUp();
                system.beforeInitialize();
                system.initialize(new LoggingInitializationContext(environment), logConfig, logFile);
            }
            catch (Exception ex) {
                logger.warn((Object)("Error opening logging config file " + logConfig), (Throwable)ex);
            }
        }
    }

    private void setLogLevels(ConfigurableApplicationContext applicationContext, ConfigurableEnvironment environment) {
        LoggingRebinder rebinder = new LoggingRebinder();
        rebinder.setEnvironment((Environment)environment);
        rebinder.onApplicationEvent(new EnvironmentChangeEvent(applicationContext, Collections.emptySet()));
    }

    private void insertPropertySources(MutablePropertySources propertySources, List<PropertySource<?>> composite) {
        MutablePropertySources incoming = new MutablePropertySources();
        ArrayList reversedComposite = new ArrayList(composite);
        Collections.reverse(reversedComposite);
        for (PropertySource propertySource : reversedComposite) {
            incoming.addFirst(propertySource);
        }
        PropertySourceBootstrapProperties remoteProperties = new PropertySourceBootstrapProperties();
        Binder.get((Environment)this.environment(incoming)).bind("spring.cloud.config", Bindable.ofInstance((Object)remoteProperties));
        if (!remoteProperties.isAllowOverride() || !remoteProperties.isOverrideNone() && remoteProperties.isOverrideSystemProperties()) {
            for (PropertySource propertySource : reversedComposite) {
                if (propertySources.contains("decrypted")) {
                    propertySources.addAfter("decrypted", propertySource);
                    continue;
                }
                propertySources.addFirst(propertySource);
            }
            return;
        }
        if (remoteProperties.isOverrideNone()) {
            for (PropertySource<?> propertySource : composite) {
                propertySources.addLast(propertySource);
            }
            return;
        }
        if (propertySources.contains("systemEnvironment")) {
            if (!remoteProperties.isOverrideSystemProperties()) {
                for (PropertySource propertySource : reversedComposite) {
                    propertySources.addAfter("systemEnvironment", propertySource);
                }
            } else {
                for (PropertySource<?> propertySource : composite) {
                    propertySources.addBefore("systemEnvironment", propertySource);
                }
            }
        } else {
            for (PropertySource<?> propertySource : composite) {
                propertySources.addLast(propertySource);
            }
        }
    }

    private Environment environment(MutablePropertySources incoming) {
        AbstractEnvironment environment = new AbstractEnvironment(){};
        for (PropertySource source : incoming) {
            environment.getPropertySources().addLast(source);
        }
        return environment;
    }

    private void handleProfiles(ConfigurableEnvironment environment) {
        if (this.bootstrapProperties.isInitializeOnContextRefresh() && !environment.getPropertySources().contains("bootstrap")) {
            return;
        }
        TreeSet<String> includeProfiles = new TreeSet<String>();
        ArrayList<String> activeProfiles = new ArrayList<String>();
        for (PropertySource propertySource : environment.getPropertySources()) {
            this.addIncludedProfilesTo(includeProfiles, propertySource, environment);
            this.addActiveProfilesTo(activeProfiles, propertySource, environment);
        }
        includeProfiles.removeAll(activeProfiles);
        for (String profile : includeProfiles) {
            activeProfiles.add(0, profile);
        }
        List activeProfilesFromEnvironment = Arrays.stream(environment.getActiveProfiles()).collect(Collectors.toList());
        if (!activeProfiles.containsAll(activeProfilesFromEnvironment)) {
            activeProfiles.addAll(activeProfilesFromEnvironment);
        }
        environment.setActiveProfiles(activeProfiles.toArray(new String[activeProfiles.size()]));
    }

    private Set<String> addIncludedProfilesTo(Set<String> profiles, PropertySource<?> propertySource, ConfigurableEnvironment environment) {
        return this.addProfilesTo(profiles, propertySource, "spring.profiles.include", environment);
    }

    private List<String> addActiveProfilesTo(List<String> profiles, PropertySource<?> propertySource, ConfigurableEnvironment environment) {
        if (!profiles.isEmpty()) {
            return profiles;
        }
        return this.addProfilesTo(profiles, propertySource, "spring.profiles.active", environment);
    }

    private <T extends Collection<String>> T addProfilesTo(T profiles, PropertySource<?> propertySource, String property, ConfigurableEnvironment environment) {
        if (propertySource instanceof CompositePropertySource) {
            for (PropertySource nestedPropertySource : ((CompositePropertySource)propertySource).getPropertySources()) {
                this.addProfilesTo(profiles, nestedPropertySource, property, environment);
            }
        } else {
            Collections.addAll(profiles, this.getProfilesForValue(propertySource.getProperty(property), environment));
        }
        return profiles;
    }

    private String[] getProfilesForValue(Object property, ConfigurableEnvironment environment) {
        String value = property == null ? null : property.toString();
        return property == null ? new String[]{} : this.resolvePlaceholdersInProfiles(value, environment);
    }

    private String[] resolvePlaceholdersInProfiles(String profiles, ConfigurableEnvironment environment) {
        return (String[])Arrays.stream(StringUtils.tokenizeToStringArray((String)profiles, (String)",")).map(arg_0 -> ((ConfigurableEnvironment)environment).resolvePlaceholders(arg_0)).toArray(String[]::new);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.bootstrapProperties.isInitializeOnContextRefresh() && event.getApplicationContext() instanceof ConfigurableApplicationContext && ((ConfigurableApplicationContext)event.getApplicationContext()).getEnvironment().getPropertySources().contains("bootstrap")) {
            this.doInitialize((ConfigurableApplicationContext)event.getApplicationContext());
        }
    }
}

