/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Pattern;

public class DslProperty<T>
implements Serializable {
    private final T clientValue;
    private final T serverValue;

    public DslProperty(T clientValue, T serverValue) {
        this.clientValue = clientValue;
        this.serverValue = serverValue;
    }

    public DslProperty(T singleValue) {
        this.clientValue = singleValue;
        this.serverValue = singleValue;
    }

    public boolean isSingleValue() {
        return this.clientValue.equals(this.serverValue) || this.clientValue != null && this.serverValue == null || this.serverValue != null && this.clientValue == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DslProperty that = (DslProperty)o;
        Object thisClientValue = this.stringPatternIfPattern(this.clientValue);
        Object thatClientValue = this.stringPatternIfPattern(that.clientValue);
        Object thisServerValue = this.stringPatternIfPattern(this.serverValue);
        Object thatServerValue = this.stringPatternIfPattern(that.serverValue);
        return Objects.equals(thisClientValue, thatClientValue) && Objects.equals(thisServerValue, thatServerValue);
    }

    private Object stringPatternIfPattern(Object value) {
        return value instanceof Pattern ? ((Pattern)value).pattern() : value;
    }

    public int hashCode() {
        return Objects.hash(this.stringPatternIfPattern(this.clientValue), this.stringPatternIfPattern(this.serverValue));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{\nclientValue=" + this.clientValue + ", \n\tserverValue=" + this.serverValue + "}";
    }

    public final T getClientValue() {
        return this.clientValue;
    }

    public final T getServerValue() {
        return this.serverValue;
    }
}

