/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.util.Objects;
import org.springframework.cloud.contract.spec.internal.ContractUtils;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.MatchingStrategy;

public class Header
extends DslProperty {
    private String name;

    public Header(String name, DslProperty dslProperty) {
        super(dslProperty.getClientValue(), dslProperty.getServerValue());
        this.name = name;
    }

    public Header(String name, MatchingStrategy value) {
        super(value);
        this.name = name;
    }

    public Header(String name, Object value) {
        super(ContractUtils.CLIENT_VALUE.apply(value), ContractUtils.SERVER_VALUE.apply(value));
        this.name = name;
    }

    public static Header build(String key, Object value) {
        if (value instanceof MatchingStrategy) {
            return new Header(key, (MatchingStrategy)value);
        }
        return new Header(key, value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Header header = (Header)o;
        return Objects.equals(this.name, header.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name);
    }

    @Override
    public String toString() {
        return "Header{\nname='" + this.name + "'} \n" + super.toString();
    }
}

