/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Collection;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.ClassBodyBuilder;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.GeneratedTestClass;
import org.springframework.cloud.contract.verifier.builder.GeneratedTestClassBuilder;
import org.springframework.cloud.contract.verifier.builder.SingleMethodBuilder;
import org.springframework.cloud.contract.verifier.builder.SingleTestGenerator;
import org.springframework.cloud.contract.verifier.config.ContractVerifierConfigProperties;
import org.springframework.cloud.contract.verifier.file.ContractMetadata;

public class JavaTestGenerator
implements SingleTestGenerator {
    @Override
    public String buildClass(ContractVerifierConfigProperties properties, Collection<ContractMetadata> listOfFiles, String includedDirectoryRelativePath, SingleTestGenerator.GeneratedClassData generatedClassData) {
        BlockBuilder builder = new BlockBuilder("\t");
        GeneratedClassMetaData metaData = new GeneratedClassMetaData(properties, listOfFiles, includedDirectoryRelativePath, generatedClassData);
        return this.classAsString(builder, metaData);
    }

    private String classAsString(BlockBuilder builder, GeneratedClassMetaData metaData) {
        SingleMethodBuilder methodBuilder = this.singleMethodBuilder(builder, metaData);
        ClassBodyBuilder bodyBuilder = this.classBodyBuilder(builder, metaData, methodBuilder);
        GeneratedTestClass generatedTestClass = this.generatedTestClass(builder, metaData, bodyBuilder);
        return generatedTestClass.asClassString();
    }

    GeneratedTestClass generatedTestClass(BlockBuilder builder, GeneratedClassMetaData metaData, ClassBodyBuilder bodyBuilder) {
        return GeneratedTestClassBuilder.builder(builder, metaData).classBodyBuilder(bodyBuilder).metaData().java().groovy().build().imports().defaultImports().userImports().customMode().json().jUnit4().jUnit5().testNG().spock().xml().messaging().restAssured().jaxRs().build().classAnnotations().defaultAnnotations().jUnit4().jUnit5().spock().build().build();
    }

    ClassBodyBuilder classBodyBuilder(BlockBuilder builder, GeneratedClassMetaData metaData, SingleMethodBuilder methodBuilder) {
        return ClassBodyBuilder.builder(builder, metaData).field().messaging().customMode().build().methodBuilder(methodBuilder);
    }

    SingleMethodBuilder singleMethodBuilder(BlockBuilder builder, GeneratedClassMetaData metaData) {
        return SingleMethodBuilder.builder(builder, metaData).methodAnnotation().jUnit4().jUnit5().testNG().spock().build().methodMetadata().jUnit().spock().build().restAssured().customMode().jaxRs().messaging();
    }
}

