/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.utils;

import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.core.KotlinDetector;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public final class FunctionClassUtils {
    private static Log logger = LogFactory.getLog(FunctionClassUtils.class);

    private FunctionClassUtils() {
    }

    public static Class<?> getStartClass() {
        ClassLoader classLoader = FunctionClassUtils.class.getClassLoader();
        return FunctionClassUtils.getStartClass(classLoader);
    }

    static Class<?> getStartClass(ClassLoader classLoader) {
        Class<?> mainClass = null;
        if (System.getenv("MAIN_CLASS") != null) {
            mainClass = ClassUtils.resolveClassName((String)System.getenv("MAIN_CLASS"), (ClassLoader)classLoader);
        } else if (System.getProperty("MAIN_CLASS") != null) {
            mainClass = ClassUtils.resolveClassName((String)System.getProperty("MAIN_CLASS"), (ClassLoader)classLoader);
        } else {
            try {
                Class<?> result = FunctionClassUtils.getStartClass(Collections.list(classLoader.getResources("META-INF/MANIFEST.MF")), classLoader);
                if (result == null) {
                    result = FunctionClassUtils.getStartClass(Collections.list(classLoader.getResources("meta-inf/manifest.mf")), classLoader);
                }
                Assert.notNull(result, (String)"Failed to locate main class");
                mainClass = result;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to discover main class. An attempt was made to discover main class as 'MAIN_CLASS' environment variable, system property as well as entry in META-INF/MANIFEST.MF (in that order).", ex);
            }
        }
        logger.info((Object)("Main class: " + String.valueOf(mainClass)));
        return mainClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Class<?> getStartClass(List<URL> list, ClassLoader classLoader) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Searching manifests: " + String.valueOf(list)));
        }
        Iterator<URL> iterator = list.iterator();
        block6: while (iterator.hasNext()) {
            URL url = iterator.next();
            try {
                Class startClass;
                block13: {
                    InputStream inputStream = null;
                    Manifest manifest = new Manifest(url.openStream());
                    logger.info((Object)("Searching for start class in manifest: " + String.valueOf(url)));
                    if (logger.isDebugEnabled()) {
                        manifest.write(System.out);
                    }
                    String startClassName = manifest.getMainAttributes().getValue("Start-Class");
                    if (!StringUtils.hasText((String)startClassName)) {
                        startClassName = manifest.getMainAttributes().getValue("Main-Class");
                    }
                    if (!StringUtils.hasText((String)startClassName)) continue;
                    startClass = ClassUtils.forName((String)startClassName, (ClassLoader)classLoader);
                    if (!KotlinDetector.isKotlinType((Class)startClass)) {
                        if (!FunctionClassUtils.isSpringBootApplication(startClass)) continue;
                        logger.info((Object)("Loaded Start Class: " + String.valueOf(startClass)));
                        Class clazz = startClass;
                        return clazz;
                    }
                    break block13;
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                PathMatchingResourcePatternResolver r = new PathMatchingResourcePatternResolver(classLoader);
                String packageName = startClass.getPackage().getName();
                Resource[] resources = r.getResources("classpath:" + packageName.replace(".", "/") + "/*.class");
                int i = 0;
                while (true) {
                    if (i >= resources.length) continue block6;
                    Resource resource = resources[i];
                    String className = packageName + "." + resource.getFilename().replace("/", ".").replace(".class", "");
                    startClass = ClassUtils.forName((String)className, (ClassLoader)classLoader);
                    if (FunctionClassUtils.isSpringBootApplication(startClass)) {
                        logger.info((Object)("Loaded Main Kotlin Class: " + String.valueOf(startClass)));
                        Class clazz = startClass;
                        return clazz;
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                logger.debug((Object)("Failed to determine Start-Class in manifest file of " + String.valueOf(url)), (Throwable)ex);
            }
        }
        return null;
    }

    private static boolean isSpringBootApplication(Class<?> startClass) {
        return startClass.getDeclaredAnnotation(SpringBootApplication.class) != null || startClass.getDeclaredAnnotation(SpringBootConfiguration.class) != null;
    }
}

