/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons;

import java.util.Collection;
import org.springframework.boot.actuate.endpoint.SanitizableData;
import org.springframework.boot.actuate.endpoint.SanitizingFunction;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.cloud.bootstrap.config.BootstrapPropertySource;
import org.springframework.cloud.kubernetes.commons.ConditionalOnSanitizeSecrets;
import org.springframework.cloud.kubernetes.commons.config.SecretsPropertySource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.PropertySource;

@Configuration(proxyBeanMethods=false)
@ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
@ConditionalOnClass(name={"org.springframework.boot.actuate.endpoint.SanitizableData"})
@ConditionalOnSanitizeSecrets
class KubernetesCommonsSanitizeAutoConfiguration {
    KubernetesCommonsSanitizeAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    SanitizingFunction secretsPropertySourceSanitizingFunction() {
        return data -> {
            BootstrapPropertySource bootstrapPropertySource;
            PropertySource source;
            PropertySource propertySource = data.getPropertySource();
            if (propertySource instanceof BootstrapPropertySource && (source = (bootstrapPropertySource = (BootstrapPropertySource)propertySource).getDelegate()) instanceof SecretsPropertySource) {
                return new SanitizableData(propertySource, data.getKey(), data.getValue()).withValue((Object)"******");
            }
            if (propertySource instanceof SecretsPropertySource) {
                return new SanitizableData(propertySource, data.getKey(), data.getValue()).withValue((Object)"******");
            }
            if (propertySource instanceof CompositePropertySource) {
                CompositePropertySource compositePropertySource = (CompositePropertySource)propertySource;
                Collection sources = compositePropertySource.getPropertySources();
                for (PropertySource one : sources) {
                    if (!one.containsProperty(data.getKey()) || !(one instanceof SecretsPropertySource)) continue;
                    return new SanitizableData(propertySource, data.getKey(), data.getValue()).withValue((Object)"******");
                }
            }
            return data;
        };
    }
}

