/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.kafka;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.docs.AssertingSpanBuilder;
import org.springframework.cloud.sleuth.docs.DocumentedSpan;
import org.springframework.cloud.sleuth.docs.TagKey;
import org.springframework.cloud.sleuth.instrument.kafka.KafkaTracingCallback;
import org.springframework.cloud.sleuth.instrument.kafka.SleuthKafkaSpan;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;

public class TracingKafkaProducer<K, V>
implements Producer<K, V> {
    private static final Log log = LogFactory.getLog(TracingKafkaProducer.class);
    private final BeanFactory beanFactory;
    private final Producer<K, V> delegate;
    private Tracer tracer;
    private Propagator propagator;
    private Propagator.Setter<ProducerRecord<?, ?>> injector;

    public TracingKafkaProducer(Producer<K, V> producer, BeanFactory beanFactory) {
        this.delegate = producer;
        this.beanFactory = beanFactory;
    }

    private Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }

    private Propagator propagator() {
        if (this.propagator == null) {
            this.propagator = (Propagator)this.beanFactory.getBean(Propagator.class);
        }
        return this.propagator;
    }

    private Propagator.Setter<ProducerRecord<?, ?>> injector() {
        if (this.injector == null) {
            this.injector = (Propagator.Setter)this.beanFactory.getBeanProvider(ResolvableType.forClassWithGenerics(Propagator.Setter.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((ParameterizedTypeReference)new ParameterizedTypeReference<ProducerRecord<?, ?>>(){})})).getIfAvailable();
        }
        return this.injector;
    }

    public void initTransactions() {
        this.delegate.initTransactions();
    }

    public void beginTransaction() throws ProducerFencedException {
        this.delegate.beginTransaction();
    }

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> map, String s) throws ProducerFencedException {
        this.delegate.sendOffsetsToTransaction(map, s);
    }

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> map, ConsumerGroupMetadata consumerGroupMetadata) throws ProducerFencedException {
        this.delegate.sendOffsetsToTransaction(map, consumerGroupMetadata);
    }

    public void commitTransaction() throws ProducerFencedException {
        this.delegate.commitTransaction();
    }

    public void abortTransaction() throws ProducerFencedException {
        this.delegate.abortTransaction();
    }

    public Future<RecordMetadata> send(ProducerRecord<K, V> producerRecord) {
        return this.send(producerRecord, null);
    }

    public Future<RecordMetadata> send(ProducerRecord<K, V> producerRecord, Callback callback) {
        AssertingSpanBuilder spanBuilder = AssertingSpanBuilder.of((DocumentedSpan)SleuthKafkaSpan.KAFKA_PRODUCER_SPAN, (Span.Builder)this.tracer().spanBuilder().kind(Span.Kind.PRODUCER)).name(SleuthKafkaSpan.KAFKA_PRODUCER_SPAN.getName()).tag((TagKey)SleuthKafkaSpan.ProducerTags.TOPIC, producerRecord.topic());
        Span span = spanBuilder.start();
        this.propagator().inject(span.context(), producerRecord, this.injector());
        try (Tracer.SpanInScope spanInScope = this.tracer().withSpan(span);){
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created producer span " + span));
            }
            Future future = this.delegate.send(producerRecord, (Callback)new KafkaTracingCallback(callback, this.tracer(), span));
            return future;
        }
    }

    public void flush() {
        this.delegate.flush();
    }

    public List<PartitionInfo> partitionsFor(String s) {
        return this.delegate.partitionsFor(s);
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.delegate.metrics();
    }

    public void close() {
        this.delegate.close();
    }

    public void close(Duration duration) {
        this.delegate.close(duration);
    }
}

