/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.tx;

import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.docs.TagKey;
import org.springframework.cloud.sleuth.instrument.tx.SleuthTxSpan;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

final class TracePlatformTransactionManagerTags {
    private TracePlatformTransactionManagerTags() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    static void tag(Span span, TransactionDefinition def, Class transactionManagerClass) {
        AssertingSpan assertingSpan = SleuthTxSpan.TX_SPAN.wrap(span).tag((TagKey)SleuthTxSpan.Tags.TRANSACTION_MANAGER, ClassUtils.getQualifiedName((Class)transactionManagerClass)).tag((TagKey)SleuthTxSpan.Tags.READ_ONLY, String.valueOf(def.isReadOnly())).tag((TagKey)SleuthTxSpan.Tags.PROPAGATION_LEVEL, TracePlatformTransactionManagerTags.propagationLevel(def)).tag((TagKey)SleuthTxSpan.Tags.ISOLATION_LEVEL, TracePlatformTransactionManagerTags.isolationLevel(def));
        if (def.getTimeout() > 0) {
            assertingSpan.tag((TagKey)SleuthTxSpan.Tags.TIMEOUT, String.valueOf(def.getTimeout()));
        }
        if (StringUtils.hasText((String)def.getName())) {
            assertingSpan.tag((TagKey)SleuthTxSpan.Tags.NAME, def.getName());
        }
    }

    private static String propagationLevel(TransactionDefinition def) {
        switch (def.getPropagationBehavior()) {
            case 0: {
                return "PROPAGATION_REQUIRED";
            }
            case 1: {
                return "PROPAGATION_SUPPORTS";
            }
            case 2: {
                return "PROPAGATION_MANDATORY";
            }
            case 3: {
                return "PROPAGATION_REQUIRES_NEW";
            }
            case 4: {
                return "PROPAGATION_NOT_SUPPORTED";
            }
            case 5: {
                return "PROPAGATION_NEVER";
            }
            case 6: {
                return "PROPAGATION_NESTED";
            }
        }
        return String.valueOf(def.getPropagationBehavior());
    }

    private static String isolationLevel(TransactionDefinition def) {
        switch (def.getIsolationLevel()) {
            case -1: {
                return "ISOLATION_DEFAULT";
            }
            case 1: {
                return "ISOLATION_READ_UNCOMMITTED";
            }
            case 2: {
                return "ISOLATION_READ_COMMITTED";
            }
            case 4: {
                return "ISOLATION_REPEATABLE_READ";
            }
            case 8: {
                return "ISOLATION_SERIALIZABLE";
            }
        }
        return String.valueOf(def.getIsolationLevel());
    }
}

