/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.util.Optional;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.instrument.web.TraceWebFilter;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.ServerRequest;
import reactor.core.publisher.Mono;

public class TraceHandlerFunction
implements HandlerFunction {
    private final HandlerFunction<?> delegate;
    private final BeanFactory beanFactory;
    private CurrentTraceContext currentTraceContext;

    public TraceHandlerFunction(HandlerFunction<?> delegate, BeanFactory beanFactory) {
        this.delegate = delegate;
        this.beanFactory = beanFactory;
    }

    public Mono<?> handle(ServerRequest serverRequest) {
        Optional spanOptional = serverRequest.attribute(TraceWebFilter.TRACE_REQUEST_ATTR);
        if (!spanOptional.isPresent()) {
            return this.delegate.handle(serverRequest);
        }
        return Mono.justOrEmpty((Optional)spanOptional).cast(Span.class).flatMap(span -> {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext().maybeScope(span.context());){
                Mono mono = this.delegate.handle(serverRequest);
                return mono;
            }
        });
    }

    private CurrentTraceContext currentTraceContext() {
        if (this.currentTraceContext == null) {
            this.currentTraceContext = (CurrentTraceContext)this.beanFactory.getBean(CurrentTraceContext.class);
        }
        return this.currentTraceContext;
    }
}

