/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.http.HttpClientHandler;
import org.springframework.cloud.sleuth.http.HttpClientResponse;
import org.springframework.cloud.sleuth.instrument.web.client.AbstractHttpHeadersFilter;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.http.HttpHeaders;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;

public class TraceResponseHttpHeadersFilter
extends AbstractHttpHeadersFilter {
    private static final Log log = LogFactory.getLog(TraceResponseHttpHeadersFilter.class);

    public TraceResponseHttpHeadersFilter(Tracer tracer, HttpClientHandler handler, Propagator propagator) {
        super(tracer, handler, propagator);
    }

    public HttpHeaders filter(HttpHeaders input, ServerWebExchange exchange) {
        Object storedSpan = exchange.getAttribute(SPAN_ATTRIBUTE);
        if (storedSpan == null) {
            return input;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Will instrument the response");
        }
        AbstractHttpHeadersFilter.ServerHttpClientResponse response = new AbstractHttpHeadersFilter.ServerHttpClientResponse(exchange.getResponse());
        this.handler.handleReceive((HttpClientResponse)response, (Span)storedSpan);
        if (log.isDebugEnabled()) {
            log.debug((Object)("The response was handled for span " + storedSpan));
        }
        return new HttpHeaders((MultiValueMap)input);
    }

    public boolean supports(HttpHeadersFilter.Type type) {
        return type.equals((Object)HttpHeadersFilter.Type.RESPONSE);
    }
}

