/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin2.sender;

import java.net.URI;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.sleuth.zipkin2.ZipkinLoadBalancer;
import org.springframework.cloud.sleuth.zipkin2.ZipkinProperties;
import org.springframework.cloud.sleuth.zipkin2.ZipkinRestTemplateCustomizer;
import org.springframework.cloud.sleuth.zipkin2.sender.LoadBalancerClientZipkinLoadBalancer;
import org.springframework.cloud.sleuth.zipkin2.sender.NoOpZipkinLoadBalancer;
import org.springframework.cloud.sleuth.zipkin2.sender.RestTemplateSender;
import org.springframework.cloud.sleuth.zipkin2.sender.ZipkinRestTemplateWrapper;
import org.springframework.cloud.sleuth.zipkin2.sender.ZipkinSenderCondition;
import org.springframework.cloud.sleuth.zipkin2.sender.ZipkinSenderProperties;
import org.springframework.cloud.sleuth.zipkin2.sender.ZipkinUrlExtractor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.reporter.Sender;

@Configuration
@ConditionalOnMissingBean(name={"zipkinSender"})
@Conditional(value={ZipkinSenderCondition.class})
@EnableConfigurationProperties(value={ZipkinSenderProperties.class})
class ZipkinRestTemplateSenderConfiguration {
    private static final Log log = LogFactory.getLog(ZipkinRestTemplateSenderConfiguration.class);
    @Autowired
    ZipkinUrlExtractor extractor;

    ZipkinRestTemplateSenderConfiguration() {
    }

    @Bean(value={"zipkinSender"})
    public Sender restTemplateSender(ZipkinProperties zipkin, ZipkinRestTemplateCustomizer zipkinRestTemplateCustomizer) {
        ZipkinRestTemplateWrapper restTemplate = new ZipkinRestTemplateWrapper(zipkin, this.extractor);
        zipkinRestTemplateCustomizer.customize(restTemplate);
        return new RestTemplateSender(restTemplate, zipkin.getBaseUrl(), (BytesEncoder<Span>)zipkin.getEncoder());
    }

    @Bean
    ZipkinUrlExtractor zipkinUrlExtractor(ZipkinLoadBalancer zipkinLoadBalancer) {
        return new CachingZipkinUrlExtractor(zipkinLoadBalancer);
    }

    @Configuration
    @ConditionalOnClass(value={LoadBalancerClient.class})
    static class DiscoveryClientZipkinUrlExtractorConfiguration {
        DiscoveryClientZipkinUrlExtractorConfiguration() {
        }

        @Configuration
        @ConditionalOnProperty(value={"spring.zipkin.discovery-client-enabled"}, havingValue="false")
        static class ZipkinClientNoOpConfiguration {
            ZipkinClientNoOpConfiguration() {
            }

            @Bean
            @ConditionalOnMissingBean
            ZipkinLoadBalancer noOpLoadBalancer(ZipkinProperties zipkinProperties) {
                return new NoOpZipkinLoadBalancer(zipkinProperties);
            }
        }

        @Configuration
        @ConditionalOnProperty(value={"spring.zipkin.discovery-client-enabled"}, havingValue="true", matchIfMissing=true)
        static class ZipkinClientLoadBalancedConfiguration {
            @Autowired(required=false)
            LoadBalancerClient client;

            ZipkinClientLoadBalancedConfiguration() {
            }

            @Bean
            @ConditionalOnMissingBean
            ZipkinLoadBalancer loadBalancerClientZipkinLoadBalancer(ZipkinProperties zipkinProperties) {
                return new LoadBalancerClientZipkinLoadBalancer(this.client, zipkinProperties);
            }
        }
    }

    @Configuration
    @ConditionalOnMissingClass(value={"org.springframework.cloud.client.loadbalancer.LoadBalancerClient"})
    static class DefaultZipkinUrlExtractorConfiguration {
        @Autowired(required=false)
        LoadBalancerClient client;

        DefaultZipkinUrlExtractorConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ZipkinLoadBalancer noOpLoadBalancer(ZipkinProperties zipkinProperties) {
            return new NoOpZipkinLoadBalancer(zipkinProperties);
        }
    }

    static class CachingZipkinUrlExtractor
    implements ZipkinUrlExtractor {
        final AtomicInteger zipkinPort = new AtomicInteger();
        private final ZipkinLoadBalancer zipkinLoadBalancer;

        CachingZipkinUrlExtractor(ZipkinLoadBalancer zipkinLoadBalancer) {
            this.zipkinLoadBalancer = zipkinLoadBalancer;
        }

        @Override
        public URI zipkinUrl(ZipkinProperties zipkinProperties) {
            int cachedZipkinPort = this.zipkinPort(zipkinProperties);
            if (cachedZipkinPort == -1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The port in Zipkin's URL [" + zipkinProperties.getBaseUrl() + "] wasn't provided - that means that load balancing might take place"));
                }
                return this.zipkinLoadBalancer.instance();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("The port in Zipkin's URL [" + zipkinProperties.getBaseUrl() + "] is provided - that means that load balancing will not take place"));
            }
            return this.noOpZipkinLoadBalancer(zipkinProperties).instance();
        }

        NoOpZipkinLoadBalancer noOpZipkinLoadBalancer(ZipkinProperties zipkinProperties) {
            return new NoOpZipkinLoadBalancer(zipkinProperties);
        }

        private int zipkinPort(ZipkinProperties zipkinProperties) {
            int cachedZipkinPort = this.zipkinPort.get();
            if (cachedZipkinPort != 0) {
                return cachedZipkinPort;
            }
            return this.calculatePort(zipkinProperties);
        }

        int calculatePort(ZipkinProperties zipkinProperties) {
            String baseUrl = zipkinProperties.getBaseUrl();
            URI uri = this.createUri(baseUrl);
            int zipkinPort = uri.getPort();
            this.zipkinPort.set(zipkinPort);
            return zipkinPort;
        }

        URI createUri(String baseUrl) {
            return URI.create(baseUrl);
        }
    }
}

