/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class PersistentEntities
implements Iterable<PersistentEntity<?, ?>> {
    private final Iterable<? extends MappingContext<?, ?>> contexts;

    public PersistentEntities(Iterable<? extends MappingContext<?, ?>> contexts) {
        Assert.notNull(contexts, (String)"MappingContexts must not be null!");
        this.contexts = contexts;
    }

    public PersistentEntity<?, ?> getPersistentEntity(Class<?> type) {
        for (MappingContext<?, ?> context : this.contexts) {
            if (!context.hasPersistentEntityFor(type)) continue;
            return context.getPersistentEntity(type);
        }
        return null;
    }

    public Iterable<TypeInformation<?>> getManagedTypes() {
        HashSet informations = new HashSet();
        for (MappingContext<?, ?> context : this.contexts) {
            informations.addAll(context.getManagedTypes());
        }
        return Collections.unmodifiableSet(informations);
    }

    @Override
    public Iterator<PersistentEntity<?, ?>> iterator() {
        ArrayList entities = new ArrayList();
        for (MappingContext<?, ?> context : this.contexts) {
            entities.addAll(context.getPersistentEntities());
        }
        return entities.iterator();
    }
}

