/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.util;

import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import java.util.Properties;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class DistributedSystemUtils
extends SpringUtils {
    public static final int DEFAULT_CACHE_SERVER_PORT = 40404;
    public static final int DEFAULT_LOCATOR_PORT = 10334;
    public static final String DURABLE_CLIENT_ID_PROPERTY_NAME = "durable-client-id";
    public static final String DURABLE_CLIENT_TIMEOUT_PROPERTY_NAME = "durable-client-timeout";
    public static final String GEMFIRE_PREFIX = "gemfire.";
    public static final String NAME_PROPERTY_NAME = "name";

    public static Properties configureDurableClient(Properties gemfireProperties, String durableClientId, Integer durableClientTimeout) {
        if (StringUtils.hasText((String)durableClientId)) {
            Assert.notNull((Object)gemfireProperties, (String)"gemfireProperties must not be null");
            gemfireProperties.setProperty(DURABLE_CLIENT_ID_PROPERTY_NAME, durableClientId);
            if (durableClientTimeout != null) {
                gemfireProperties.setProperty(DURABLE_CLIENT_TIMEOUT_PROPERTY_NAME, durableClientTimeout.toString());
            }
        }
        return gemfireProperties;
    }

    public static boolean isConnected(DistributedSystem distributedSystem) {
        return distributedSystem != null && distributedSystem.isConnected();
    }

    public static boolean isNotConnected(DistributedSystem distributedSystem) {
        return !DistributedSystemUtils.isConnected(distributedSystem);
    }

    public static <T extends DistributedSystem> T getDistributedSystem() {
        return (T)InternalDistributedSystem.getAnyInstance();
    }

    public static <T extends DistributedSystem> T getDistributedSystem(GemFireCache gemfireCache) {
        return (T)(gemfireCache != null ? gemfireCache.getDistributedSystem() : null);
    }
}

