/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.internal.GemFireVersion;
import org.springframework.data.gemfire.config.support.GemfireFeature;
import org.springframework.data.gemfire.util.CacheUtils;
import org.springframework.util.ClassUtils;
import org.w3c.dom.Element;

public abstract class GemfireUtils
extends CacheUtils {
    public static final String GEMFIRE_NAME = GemFireVersion.getProductName();
    public static final String GEMFIRE_VERSION = CacheFactory.getVersion();
    private static final String ASYNC_EVENT_QUEUE_ELEMENT_NAME = "async-event-queue";
    private static final String ASYNC_EVENT_QUEUE_TYPE_NAME = "com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue";
    private static final String CQ_ELEMENT_NAME = "cq-listener-container";
    private static final String CQ_TYPE_NAME = "com.gemstone.gemfire.cache.query.internal.cq.CqServiceFactoryImpl";
    private static final String GATEWAY_RECEIVER_ELEMENT_NAME = "gateway-receiver";
    private static final String GATEWAY_RECEIVER_TYPE_NAME = "com.gemstone.gemfire.internal.cache.wan.GatewayReceiverFactoryImpl";
    private static final String GATEWAY_SENDER_ELEMENT_NAME = "gateway-sender";
    private static final String GATEWAY_SENDER_TYPE_NAME = "com.gemstone.gemfire.internal.cache.wan.GatewaySenderFactoryImpl";

    public static boolean isClassAvailable(String fullyQualifiedClassName) {
        return ClassUtils.isPresent((String)fullyQualifiedClassName, (ClassLoader)GemfireUtils.class.getClassLoader());
    }

    public static boolean isGemfireFeatureAvailable(GemfireFeature feature) {
        boolean featureAvailable = !GemfireFeature.AEQ.equals((Object)feature) || GemfireUtils.isAsyncEventQueueAvailable();
        featureAvailable &= !GemfireFeature.CONTINUOUS_QUERY.equals((Object)feature) || GemfireUtils.isContinuousQueryAvailable();
        return featureAvailable &= !GemfireFeature.WAN.equals((Object)feature) || GemfireUtils.isGatewayAvailable();
    }

    public static boolean isGemfireFeatureAvailable(Element element) {
        boolean featureAvailable = !GemfireUtils.isAsyncEventQueue(element) || GemfireUtils.isAsyncEventQueueAvailable();
        featureAvailable &= !GemfireUtils.isContinuousQuery(element) || GemfireUtils.isContinuousQueryAvailable();
        return featureAvailable &= !GemfireUtils.isGateway(element) || GemfireUtils.isGatewayAvailable();
    }

    public static boolean isGemfireFeatureUnavailable(GemfireFeature feature) {
        return !GemfireUtils.isGemfireFeatureAvailable(feature);
    }

    public static boolean isGemfireFeatureUnavailable(Element element) {
        return !GemfireUtils.isGemfireFeatureAvailable(element);
    }

    private static boolean isAsyncEventQueue(Element element) {
        return ASYNC_EVENT_QUEUE_ELEMENT_NAME.equals(element.getLocalName());
    }

    private static boolean isAsyncEventQueueAvailable() {
        return GemfireUtils.isClassAvailable(ASYNC_EVENT_QUEUE_TYPE_NAME);
    }

    private static boolean isContinuousQuery(Element element) {
        return CQ_ELEMENT_NAME.equals(element.getLocalName());
    }

    private static boolean isContinuousQueryAvailable() {
        return GemfireUtils.isClassAvailable(CQ_TYPE_NAME);
    }

    private static boolean isGateway(Element element) {
        String elementLocalName = element.getLocalName();
        return GATEWAY_RECEIVER_ELEMENT_NAME.equals(elementLocalName) || GATEWAY_SENDER_ELEMENT_NAME.equals(elementLocalName);
    }

    private static boolean isGatewayAvailable() {
        return GemfireUtils.isClassAvailable(GATEWAY_SENDER_TYPE_NAME);
    }

    public static void main(String ... args) {
        System.out.printf("GemFire Product Name (%1$s) Version (%2$s)%n", GEMFIRE_NAME, GEMFIRE_VERSION);
    }
}

