/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexExistsException;
import com.gemstone.gemfire.cache.query.IndexInvalidException;
import com.gemstone.gemfire.cache.query.IndexNameConflictException;
import com.gemstone.gemfire.cache.query.IndexStatistics;
import com.gemstone.gemfire.cache.query.QueryService;
import java.util.Collection;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.data.gemfire.GemfireIndexException;
import org.springframework.data.gemfire.IndexType;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class IndexFactoryBean
implements InitializingBean,
FactoryBean<Index>,
BeanNameAware,
BeanFactoryAware {
    private boolean define = false;
    private boolean override = true;
    private BeanFactory beanFactory;
    private Index index;
    private IndexType indexType;
    private QueryService queryService;
    private RegionService cache;
    private String beanName;
    private String expression;
    private String from;
    private String imports;
    private String indexName;
    private String name;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.cache, (String)"The GemFire Cache reference must not be null!");
        this.queryService = this.lookupQueryService();
        Assert.notNull((Object)this.queryService, (String)"QueryService is required to create an Index");
        Assert.hasText((String)this.expression, (String)"Index 'expression' is required");
        Assert.hasText((String)this.from, (String)"Index 'from clause' is required");
        if (IndexType.isKey(this.indexType)) {
            Assert.isNull((Object)this.imports, (String)"'imports' are not supported with a KEY Index");
        }
        this.indexName = StringUtils.hasText((String)this.name) ? this.name : this.beanName;
        Assert.hasText((String)this.indexName, (String)"Index 'name' is required");
        this.index = this.createIndex(this.queryService, this.indexName);
    }

    QueryService doLookupQueryService() {
        return this.queryService != null ? this.queryService : (this.cache instanceof ClientCache ? ((ClientCache)this.cache).getLocalQueryService() : this.cache.getQueryService());
    }

    QueryService lookupQueryService() {
        if (this.getBeanFactory().containsBean("gemfireIndexDefinitionQueryService")) {
            return (QueryService)this.getBeanFactory().getBean("gemfireIndexDefinitionQueryService", QueryService.class);
        }
        return this.registerQueryServiceBean(this.doLookupQueryService());
    }

    QueryService registerQueryServiceBean(QueryService queryService) {
        if (this.isDefine()) {
            ((ConfigurableBeanFactory)this.getBeanFactory()).registerSingleton("gemfireIndexDefinitionQueryService", (Object)queryService);
        }
        return queryService;
    }

    Index createIndex(QueryService queryService, String indexName) throws Exception {
        Index existingIndex = this.getExistingIndex(queryService, indexName);
        if (existingIndex != null) {
            if (this.override) {
                queryService.removeIndex(existingIndex);
            } else {
                return existingIndex;
            }
        }
        try {
            if (IndexType.isKey(this.indexType)) {
                return this.createKeyIndex(queryService, indexName, this.expression, this.from);
            }
            if (IndexType.isHash(this.indexType)) {
                return this.createHashIndex(queryService, indexName, this.expression, this.from, this.imports);
            }
            return this.createFunctionalIndex(queryService, indexName, this.expression, this.from, this.imports);
        }
        catch (IndexExistsException e) {
            throw new GemfireIndexException(String.format("An Index with a different name having the same definition as this Index (%1$s) already exists", indexName), e);
        }
        catch (IndexNameConflictException e) {
            throw new GemfireIndexException(String.format("Failed to remove the existing Index%1$sbefore re-creating Index with name (%2$s)", this.override ? " on override " : " ", indexName), e);
        }
        catch (Exception e) {
            Collection indexes;
            if (existingIndex != null && (CollectionUtils.isEmpty((Collection)(indexes = queryService.getIndexes())) || !indexes.contains(existingIndex))) {
                queryService.getIndexes().add(existingIndex);
                return existingIndex;
            }
            throw e;
        }
    }

    Index createKeyIndex(QueryService queryService, String indexName, String expression, String from) throws Exception {
        if (this.isDefine()) {
            queryService.defineKeyIndex(indexName, expression, from);
            return new IndexWrapper(queryService, indexName);
        }
        return queryService.createKeyIndex(indexName, expression, from);
    }

    Index createHashIndex(QueryService queryService, String indexName, String expression, String from, String imports) throws Exception {
        boolean hasImports = StringUtils.hasText((String)imports);
        if (this.isDefine()) {
            if (hasImports) {
                queryService.defineHashIndex(indexName, expression, from, imports);
            } else {
                queryService.defineHashIndex(indexName, expression, from);
            }
            return new IndexWrapper(queryService, indexName);
        }
        if (hasImports) {
            return queryService.createHashIndex(indexName, expression, from, imports);
        }
        return queryService.createHashIndex(indexName, expression, from);
    }

    Index createFunctionalIndex(QueryService queryService, String indexName, String expression, String from, String imports) throws Exception {
        boolean hasImports = StringUtils.hasText((String)imports);
        if (this.isDefine()) {
            if (hasImports) {
                queryService.defineIndex(indexName, expression, from, imports);
            } else {
                queryService.defineIndex(indexName, expression, from);
            }
            return new IndexWrapper(queryService, indexName);
        }
        if (hasImports) {
            return queryService.createIndex(indexName, expression, from, imports);
        }
        return queryService.createIndex(indexName, expression, from);
    }

    Index getExistingIndex(QueryService queryService, String indexName) {
        for (Index index : CollectionUtils.nullSafeCollection(queryService.getIndexes())) {
            if (!index.getName().equalsIgnoreCase(indexName)) continue;
            return index;
        }
        return null;
    }

    public Index getObject() {
        this.index = this.index != null ? this.index : this.getExistingIndex(this.queryService, this.indexName);
        return this.index;
    }

    public Class<?> getObjectType() {
        return this.index != null ? this.index.getClass() : Index.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setCache(RegionService cache) {
        this.cache = cache;
    }

    public void setQueryService(QueryService service) {
        this.queryService = service;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected BeanFactory getBeanFactory() {
        Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"'beanFactory' was not properly initialized");
        return this.beanFactory;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDefine(boolean define) {
        this.define = define;
    }

    protected boolean isDefine() {
        return this.define;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setImports(String imports) {
        this.imports = imports;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    public void setType(String type) {
        this.setType(IndexType.valueOfIgnoreCase(type));
    }

    public void setType(IndexType indexType) {
        this.indexType = indexType;
    }

    protected static final class IndexWrapper
    implements Index {
        private Index index;
        private final QueryService queryService;
        private final String indexName;

        protected IndexWrapper(QueryService queryService, String indexName) {
            Assert.notNull((Object)queryService, (String)"QueryService must not be null");
            Assert.hasText((String)indexName, (String)"The name of the Index must be specified!");
            this.queryService = queryService;
            this.indexName = indexName;
        }

        protected synchronized Index getIndex() {
            if (this.index == null) {
                String localIndexName = this.getIndexName();
                for (Index localIndex : this.getQueryService().getIndexes()) {
                    if (!localIndex.getName().equals(localIndexName)) continue;
                    this.index = localIndex;
                    break;
                }
                if (this.index == null) {
                    throw new GemfireIndexException(new IndexInvalidException(String.format("index with name (%1$s) was not found", localIndexName)));
                }
            }
            return this.index;
        }

        protected String getIndexName() {
            Assert.state((boolean)StringUtils.hasText((String)this.indexName), (String)"The Index 'name' was not properly initialized!");
            return this.indexName;
        }

        protected QueryService getQueryService() {
            return this.queryService;
        }

        public String getName() {
            return this.getIndex().getName();
        }

        public String getCanonicalizedFromClause() {
            return this.getIndex().getCanonicalizedFromClause();
        }

        public String getCanonicalizedIndexedExpression() {
            return this.getIndex().getCanonicalizedIndexedExpression();
        }

        public String getCanonicalizedProjectionAttributes() {
            return this.getIndex().getCanonicalizedProjectionAttributes();
        }

        public String getFromClause() {
            return this.getIndex().getFromClause();
        }

        public String getIndexedExpression() {
            return this.getIndex().getIndexedExpression();
        }

        public String getProjectionAttributes() {
            return this.getIndex().getProjectionAttributes();
        }

        public Region<?, ?> getRegion() {
            return this.getIndex().getRegion();
        }

        public IndexStatistics getStatistics() {
            return this.getIndex().getStatistics();
        }

        public com.gemstone.gemfire.cache.query.IndexType getType() {
            return this.getIndex().getType();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof IndexWrapper) && !(obj instanceof Index)) {
                return false;
            }
            if (obj instanceof IndexWrapper) {
                return this.getIndexName().equals(((IndexWrapper)obj).getIndexName());
            }
            return this.getIndex().equals(obj);
        }

        public int hashCode() {
            int hashValue = 37;
            hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode((Object)this.getIndexName());
            hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode((Object)this.index);
            return hashValue;
        }

        public String toString() {
            return this.index != null ? String.valueOf(this.index) : this.getIndexName();
        }
    }
}

