/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.InterestRegistrationListener;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.server.ServerLoadProbe;
import java.util.Map;
import java.util.Set;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.config.annotation.CacheServerApplication;
import org.springframework.data.gemfire.config.annotation.PeerCacheConfiguration;
import org.springframework.data.gemfire.server.CacheServerFactoryBean;
import org.springframework.data.gemfire.server.SubscriptionEvictionPolicy;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.SpringUtils;

@Configuration
public class CacheServerConfiguration
extends PeerCacheConfiguration {
    protected static final boolean DEFAULT_AUTO_STARTUP = true;
    protected static final String DEFAULT_NAME = "SpringBasedCacheServerApplication";
    private boolean autoStartup = true;
    private Integer maxConnections;
    private Integer maxMessageCount;
    private Integer maxThreads;
    private Integer maxTimeBetweenPings;
    private Integer messageTimeToLive;
    private Integer port;
    private Integer socketBufferSize;
    private Integer subscriptionCapacity;
    private Long loadPollInterval;
    private ServerLoadProbe serverLoadProbe;
    private Set<InterestRegistrationListener> interestRegistrationListeners;
    private String bindAddress;
    private String hostnameForClients;
    private String subscriptionDiskStoreName;
    private SubscriptionEvictionPolicy subscriptionEvictionPolicy;

    @Bean
    public CacheServerFactoryBean gemfireCacheServer(Cache gemfireCache) {
        CacheServerFactoryBean gemfireCacheServer = new CacheServerFactoryBean();
        gemfireCacheServer.setCache(gemfireCache);
        gemfireCacheServer.setAutoStartup(this.autoStartup());
        gemfireCacheServer.setBindAddress(this.bindAddress());
        gemfireCacheServer.setHostNameForClients(this.hostnameForClients());
        gemfireCacheServer.setListeners(this.interestRegistrationListeners());
        gemfireCacheServer.setLoadPollInterval(this.loadPollInterval());
        gemfireCacheServer.setMaxConnections(this.maxConnections());
        gemfireCacheServer.setMaxMessageCount(this.maxMessageCount());
        gemfireCacheServer.setMaxThreads(this.maxThreads());
        gemfireCacheServer.setMaxTimeBetweenPings(this.maxTimeBetweenPings());
        gemfireCacheServer.setMessageTimeToLive(this.messageTimeToLive());
        gemfireCacheServer.setPort(this.port());
        gemfireCacheServer.setServerLoadProbe(this.serverLoadProbe());
        gemfireCacheServer.setSocketBufferSize(this.socketBufferSize());
        gemfireCacheServer.setSubscriptionCapacity(this.subscriptionCapacity());
        gemfireCacheServer.setSubscriptionDiskStore(this.subscriptionDiskStoreName());
        gemfireCacheServer.setSubscriptionEvictionPolicy(this.subscriptionEvictionPolicy());
        return gemfireCacheServer;
    }

    @Override
    protected void configureOther(AnnotationMetadata importMetadata) {
        super.configureCache(importMetadata);
        if (this.isCacheServerApplication(importMetadata)) {
            Map cacheServerApplicationMetadata = importMetadata.getAnnotationAttributes(this.getAnnotationTypeName());
            this.setAutoStartup(Boolean.TRUE.equals(cacheServerApplicationMetadata.get("autoStartup")));
            this.setBindAddress((String)cacheServerApplicationMetadata.get("bindAddress"));
            this.setHostnameForClients((String)cacheServerApplicationMetadata.get("hostnameForClients"));
            this.setLoadPollInterval((Long)cacheServerApplicationMetadata.get("loadPollInterval"));
            this.setMaxConnections((Integer)cacheServerApplicationMetadata.get("maxConnections"));
            this.setMaxMessageCount((Integer)cacheServerApplicationMetadata.get("maxMessageCount"));
            this.setMaxThreads((Integer)cacheServerApplicationMetadata.get("maxThreads"));
            this.setMaxTimeBetweenPings((Integer)cacheServerApplicationMetadata.get("maxTimeBetweenPings"));
            this.setMessageTimeToLive((Integer)cacheServerApplicationMetadata.get("messageTimeToLive"));
            this.setPort((Integer)cacheServerApplicationMetadata.get("port"));
            this.setSocketBufferSize((Integer)cacheServerApplicationMetadata.get("socketBufferSize"));
            this.setSubscriptionCapacity((Integer)cacheServerApplicationMetadata.get("subscriptionCapacity"));
            this.setSubscriptionDiskStoreName((String)cacheServerApplicationMetadata.get("subscriptionDiskStoreName"));
            this.setSubscriptionEvictionPolicy((SubscriptionEvictionPolicy)((Object)cacheServerApplicationMetadata.get("subscriptionEvictionPolicy")));
        }
    }

    @Override
    protected Class getAnnotationType() {
        return CacheServerApplication.class;
    }

    void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    protected boolean autoStartup() {
        return this.autoStartup;
    }

    void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    protected String bindAddress() {
        return SpringUtils.defaultIfNull(this.bindAddress, "");
    }

    void setHostnameForClients(String hostnameForClients) {
        this.hostnameForClients = hostnameForClients;
    }

    protected String hostnameForClients() {
        return SpringUtils.defaultIfNull(this.hostnameForClients, "");
    }

    void setInterestRegistrationListeners(Set<InterestRegistrationListener> interestRegistrationListeners) {
        this.interestRegistrationListeners = interestRegistrationListeners;
    }

    protected Set<InterestRegistrationListener> interestRegistrationListeners() {
        return CollectionUtils.nullSafeSet(this.interestRegistrationListeners);
    }

    void setLoadPollInterval(Long loadPollInterval) {
        this.loadPollInterval = loadPollInterval;
    }

    protected Long loadPollInterval() {
        return SpringUtils.defaultIfNull(this.loadPollInterval, 5000L);
    }

    void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    protected Integer maxConnections() {
        return SpringUtils.defaultIfNull(this.maxConnections, 800);
    }

    void setMaxMessageCount(Integer maxMessageCount) {
        this.maxMessageCount = maxMessageCount;
    }

    protected Integer maxMessageCount() {
        return SpringUtils.defaultIfNull(this.maxMessageCount, 230000);
    }

    void setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
    }

    protected Integer maxThreads() {
        return SpringUtils.defaultIfNull(this.maxThreads, 0);
    }

    void setMaxTimeBetweenPings(Integer maxTimeBetweenPings) {
        this.maxTimeBetweenPings = maxTimeBetweenPings;
    }

    protected Integer maxTimeBetweenPings() {
        return SpringUtils.defaultIfNull(this.maxTimeBetweenPings, 60000);
    }

    void setMessageTimeToLive(Integer messageTimeToLive) {
        this.messageTimeToLive = messageTimeToLive;
    }

    protected Integer messageTimeToLive() {
        return SpringUtils.defaultIfNull(this.messageTimeToLive, 180);
    }

    void setPort(Integer port) {
        this.port = port;
    }

    protected Integer port() {
        return SpringUtils.defaultIfNull(this.port, 40404);
    }

    void setServerLoadProbe(ServerLoadProbe serverLoadProbe) {
        this.serverLoadProbe = serverLoadProbe;
    }

    protected ServerLoadProbe serverLoadProbe() {
        return SpringUtils.defaultIfNull(this.serverLoadProbe, CacheServer.DEFAULT_LOAD_PROBE);
    }

    void setSocketBufferSize(Integer socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    protected Integer socketBufferSize() {
        return SpringUtils.defaultIfNull(this.socketBufferSize, 32768);
    }

    void setSubscriptionCapacity(Integer subscriptionCapacity) {
        this.subscriptionCapacity = subscriptionCapacity;
    }

    protected Integer subscriptionCapacity() {
        return SpringUtils.defaultIfNull(this.subscriptionCapacity, 1);
    }

    void setSubscriptionDiskStoreName(String subscriptionDiskStoreName) {
        this.subscriptionDiskStoreName = subscriptionDiskStoreName;
    }

    protected String subscriptionDiskStoreName() {
        return this.subscriptionDiskStoreName;
    }

    void setSubscriptionEvictionPolicy(SubscriptionEvictionPolicy subscriptionEvictionPolicy) {
        this.subscriptionEvictionPolicy = subscriptionEvictionPolicy;
    }

    protected SubscriptionEvictionPolicy subscriptionEvictionPolicy() {
        return SpringUtils.defaultIfNull(this.subscriptionEvictionPolicy, SubscriptionEvictionPolicy.DEFAULT);
    }

    @Override
    public String toString() {
        return DEFAULT_NAME;
    }
}

