/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.GenericRegionFactoryBean;
import org.springframework.data.gemfire.LocalRegionFactoryBean;
import org.springframework.data.gemfire.PartitionedRegionFactoryBean;
import org.springframework.data.gemfire.ReplicatedRegionFactoryBean;
import org.springframework.data.gemfire.client.ClientRegionFactoryBean;
import org.springframework.data.gemfire.config.annotation.EnableOffHeap;
import org.springframework.data.gemfire.config.annotation.support.EmbeddedServiceConfigurationSupport;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.PropertiesBuilder;

public class OffHeapConfiguration
extends EmbeddedServiceConfigurationSupport {
    @Override
    protected Class getAnnotationType() {
        return EnableOffHeap.class;
    }

    @Override
    protected void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, Map<String, Object> annotationAttributes, BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(OffHeapBeanFactoryPostProcessor.class);
        builder.addConstructorArgValue(annotationAttributes.get("regionNames"));
        registry.registerBeanDefinition(this.generateBeanName(OffHeapBeanFactoryPostProcessor.class), (BeanDefinition)builder.getBeanDefinition());
    }

    @Override
    protected Properties toGemFireProperties(Map<String, Object> annotationAttributes) {
        PropertiesBuilder gemfireProperties = PropertiesBuilder.create();
        gemfireProperties.setProperty("off-heap-memory-size", annotationAttributes.get("memorySize"));
        return gemfireProperties.build();
    }

    protected static class OffHeapBeanFactoryPostProcessor
    implements BeanFactoryPostProcessor {
        protected static final Set<String> REGION_FACTORY_BEAN_TYPES = new HashSet<String>(5);
        private final Set<String> regionNames;

        protected OffHeapBeanFactoryPostProcessor(String[] regionNames) {
            this(CollectionUtils.asSet(ArrayUtils.nullSafeArray(regionNames, String.class)));
        }

        protected OffHeapBeanFactoryPostProcessor(Set<String> regionNames) {
            this.regionNames = CollectionUtils.nullSafeSet(regionNames);
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            for (String beanName : beanFactory.getBeanDefinitionNames()) {
                BeanDefinition bean = beanFactory.getBeanDefinition(beanName);
                if (!this.isTargetedRegionBean(beanName, bean, beanFactory)) continue;
                bean.getPropertyValues().addPropertyValue("offHeap", (Object)true);
            }
        }

        boolean isTargetedRegionBean(String beanName, BeanDefinition bean, ConfigurableListableBeanFactory beanFactory) {
            return this.isRegionBean(bean) && this.isNamedRegion(beanName, bean, beanFactory);
        }

        boolean isRegionBean(BeanDefinition bean) {
            return bean != null && REGION_FACTORY_BEAN_TYPES.contains(bean.getBeanClassName());
        }

        boolean isNamedRegion(String beanName, BeanDefinition bean, ConfigurableListableBeanFactory beanFactory) {
            return CollectionUtils.isEmpty(this.regionNames) || CollectionUtils.containsAny(this.regionNames, this.getBeanNames(beanName, bean, (BeanFactory)beanFactory));
        }

        Collection<String> getBeanNames(String beanName, BeanDefinition bean, BeanFactory beanFactory) {
            Object regionNameValue;
            HashSet<String> beanNames = new HashSet<String>();
            beanNames.add(beanName);
            Collections.addAll(beanNames, beanFactory.getAliases(beanName));
            PropertyValue regionName = bean.getPropertyValues().getPropertyValue("regionName");
            if (regionName != null && (regionNameValue = regionName.getValue()) != null) {
                beanNames.add(regionNameValue.toString());
            }
            return beanNames;
        }

        static {
            REGION_FACTORY_BEAN_TYPES.add(ClientRegionFactoryBean.class.getName());
            REGION_FACTORY_BEAN_TYPES.add(GenericRegionFactoryBean.class.getName());
            REGION_FACTORY_BEAN_TYPES.add(LocalRegionFactoryBean.class.getName());
            REGION_FACTORY_BEAN_TYPES.add(PartitionedRegionFactoryBean.class.getName());
            REGION_FACTORY_BEAN_TYPES.add(ReplicatedRegionFactoryBean.class.getName());
        }
    }
}

