/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.mapping;

import com.gemstone.gemfire.cache.Region;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.util.Assert;

public class Regions
implements Iterable<Region<?, ?>> {
    private final Map<String, Region<?, ?>> regions;
    private final MappingContext<? extends GemfirePersistentEntity<?>, ?> mappingContext;

    public Regions(Iterable<Region<?, ?>> regions, MappingContext<? extends GemfirePersistentEntity<?>, ?> mappingContext) {
        Assert.notNull(regions, (String)"Regions must not be null");
        Assert.notNull(mappingContext, (String)"MappingContext must not be null");
        HashMap regionMap = new HashMap();
        for (Region<?, ?> region : regions) {
            regionMap.put(region.getName(), region);
            regionMap.put(region.getFullPath(), region);
        }
        this.regions = Collections.unmodifiableMap(regionMap);
        this.mappingContext = mappingContext;
    }

    public <T> Region<?, T> getRegion(Class<T> entityType) {
        Assert.notNull(entityType, (String)"entityType must not be null");
        GemfirePersistentEntity entity = (GemfirePersistentEntity)this.mappingContext.getPersistentEntity(entityType);
        String regionName = entity != null ? entity.getRegionName() : entityType.getSimpleName();
        return this.regions.get(regionName);
    }

    public <S, T> Region<S, T> getRegion(String namePath) {
        Assert.hasText((String)namePath, (String)"Region name/path is required");
        return this.regions.get(namePath);
    }

    @Override
    public Iterator<Region<?, ?>> iterator() {
        return this.regions.values().iterator();
    }
}

