/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.execution;

import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Function;
import org.springframework.data.gemfire.function.execution.AbstractFunctionExecution;
import org.springframework.data.gemfire.function.execution.AbstractFunctionTemplate;
import org.springframework.data.gemfire.function.execution.GemfireOnRegionOperations;
import org.springframework.data.gemfire.function.execution.RegionFunctionExecution;
import org.springframework.util.Assert;

public class GemfireOnRegionFunctionTemplate
extends AbstractFunctionTemplate
implements GemfireOnRegionOperations {
    private Region<?, ?> region;

    public GemfireOnRegionFunctionTemplate(Region<?, ?> region) {
        Assert.notNull(region, (String)"Region cannot be null");
        this.region = region;
    }

    @Override
    public <T> Iterable<T> execute(Function function, Set<?> keys, Object ... args) {
        return this.execute(new RegionFunctionExecution(this.region).setKeys(keys).setFunction(function).setTimeout(this.timeout).setArgs(args));
    }

    @Override
    public <T> Iterable<T> execute(String functionId, Set<?> keys, Object ... args) {
        return this.execute(new RegionFunctionExecution(this.region).setKeys(keys).setFunctionId(functionId).setTimeout(this.timeout).setArgs(args));
    }

    @Override
    public <T> T executeAndextract(String functionId, Set<?> keys, Object ... args) {
        return this.executeAndExtract(new RegionFunctionExecution(this.region).setKeys(keys).setFunctionId(functionId).setTimeout(this.timeout).setArgs(args));
    }

    @Override
    protected AbstractFunctionExecution getFunctionExecution() {
        return new RegionFunctionExecution(this.region);
    }

    @Override
    public void executeWithNoResult(String functionId, Set<?> keys, Object ... args) {
        this.execute(new RegionFunctionExecution(this.region).setKeys(keys).setFunctionId(functionId).setTimeout(this.timeout).setArgs(args), false);
    }
}

