/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.mapping;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.gemfire.mapping.GemfirePersistentProperty;
import org.springframework.data.gemfire.mapping.annotation.Region;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.util.TypeInformation;

public class GemfirePersistentEntity<T>
extends BasicPersistentEntity<T, GemfirePersistentProperty> {
    private final Annotation regionAnnotation;
    private final String regionName;

    protected static Annotation resolveRegionAnnotation(Class<?> persistentEntityType) {
        for (Class<? extends Annotation> regionAnnotationType : Region.REGION_ANNOTATION_TYPES) {
            Annotation regionAnnotation = AnnotatedElementUtils.getMergedAnnotation(persistentEntityType, regionAnnotationType);
            if (regionAnnotation == null) continue;
            return regionAnnotation;
        }
        return null;
    }

    protected static String resolveRegionName(Class<?> persistentEntityType, Annotation regionAnnotation) {
        String regionName = Optional.ofNullable(regionAnnotation).map(annotation -> GemfirePersistentEntity.getAnnotationAttributeStringValue(annotation, "value")).orElse(null);
        return SpringUtils.defaultIfEmpty(regionName, persistentEntityType.getSimpleName());
    }

    protected static String getAnnotationAttributeStringValue(Annotation annotation, String attributeName) {
        return AnnotationAttributes.fromMap((Map)AnnotationUtils.getAnnotationAttributes((Annotation)annotation)).getString(attributeName);
    }

    public GemfirePersistentEntity(TypeInformation<T> information) {
        super(information);
        Class rawType = information.getType();
        this.regionAnnotation = GemfirePersistentEntity.resolveRegionAnnotation(rawType);
        this.regionName = GemfirePersistentEntity.resolveRegionName(rawType, this.regionAnnotation);
    }

    public <T extends Annotation> T getRegionAnnotation() {
        return (T)this.regionAnnotation;
    }

    public Class<? extends Annotation> getRegionAnnotationType() {
        return Optional.ofNullable(this.getRegionAnnotation()).map(annotation -> ((Annotation)annotation).annotationType()).orElse(null);
    }

    public String getRegionName() {
        return this.regionName;
    }

    protected GemfirePersistentProperty returnPropertyIfBetterIdPropertyCandidateOrNull(GemfirePersistentProperty property) {
        if (property.isIdProperty()) {
            GemfirePersistentProperty idProperty = (GemfirePersistentProperty)this.getIdProperty();
            if (idProperty != null) {
                if (idProperty.isExplicitIdProperty()) {
                    if (property.isExplicitIdProperty()) {
                        throw new MappingException(String.format("Attempt to add explicit id property [%1$s] but already have id property [%2$s] registered as explicit; Please check your object [%3$s] mapping configuration", property.getName(), idProperty.getName(), this.getType().getName()));
                    }
                    return null;
                }
                return property.isExplicitIdProperty() ? property : null;
            }
            return property;
        }
        return null;
    }
}

