/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.gemfire.config.annotation.EnableSsl;
import org.springframework.data.gemfire.config.annotation.support.EmbeddedServiceConfigurationSupport;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.PropertiesBuilder;
import org.springframework.util.StringUtils;

public class SslConfiguration
extends EmbeddedServiceConfigurationSupport {
    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableSsl.class;
    }

    @Override
    protected Properties toGemFireProperties(Map<String, Object> annotationAttributesMap) {
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap(annotationAttributesMap);
        PropertiesBuilder gemfireProperties = PropertiesBuilder.create();
        Set<EnableSsl.Component> components = this.resolveComponents(annotationAttributes);
        gemfireProperties.setProperty("ssl-enabled-components", StringUtils.collectionToCommaDelimitedString((Collection)components.stream().map(EnableSsl.Component::toString).collect(Collectors.toSet()))).setProperty("ssl-ciphers", this.resolveProperty(this.sslProperty("ciphers"), StringUtils.arrayToCommaDelimitedString((Object[])annotationAttributes.getStringArray("ciphers")))).setPropertyIfNotDefault("ssl-default-alias", this.resolveProperty(this.sslProperty("certificate.alias.default"), annotationAttributes.getString("defaultCertificateAlias")), "").setProperty("ssl-endpoint-identification-enabled", this.resolveProperty(this.sslProperty("enable-endpoint-identification"), annotationAttributes.getBoolean("enableEndpointIdentification"))).setProperty("ssl-keystore", this.resolveProperty(this.sslProperty("keystore"), annotationAttributes.getString("keystore"))).setProperty("ssl-keystore-password", this.resolveProperty(this.sslProperty("keystore.password"), annotationAttributes.getString("keystorePassword"))).setProperty("ssl-keystore-type", this.resolveProperty(this.sslProperty("keystore.type"), annotationAttributes.getString("keystoreType"))).setProperty("ssl-protocols", this.resolveProperty(this.sslProperty("protocols"), StringUtils.arrayToCommaDelimitedString((Object[])annotationAttributes.getStringArray("protocols")))).setProperty("ssl-require-authentication", this.resolveProperty(this.sslProperty("require-authentication"), annotationAttributes.getBoolean("requireAuthentication"))).setProperty("ssl-truststore", this.resolveProperty(this.sslProperty("truststore"), annotationAttributes.getString("truststore"))).setProperty("ssl-truststore-password", this.resolveProperty(this.sslProperty("truststore.password"), annotationAttributes.getString("truststorePassword"))).setProperty("ssl-truststore-type", this.resolveProperty(this.sslProperty("truststore.type"), annotationAttributes.getString("truststoreType"))).setProperty("ssl-use-default-context", this.resolveProperty(this.sslProperty("use-default-context"), annotationAttributes.getBoolean("useDefaultContext"))).setProperty("ssl-web-require-authentication", this.resolveProperty(this.sslProperty("web-require-authentication"), annotationAttributes.getBoolean("webRequireAuthentication")));
        this.configureComponentCertificateAliases(annotationAttributes, gemfireProperties);
        return gemfireProperties.build();
    }

    private Set<EnableSsl.Component> resolveComponents(AnnotationAttributes annotationAttributes) {
        Set<EnableSsl.Component> components = Arrays.stream((Object[])Optional.of(this.resolveProperty(this.sslProperty("components"), "")).filter(StringUtils::hasText).map(StringUtils::commaDelimitedListToStringArray).orElseGet(() -> new String[0])).map(EnableSsl.Component::valueOfName).collect(Collectors.toSet());
        components = components.isEmpty() ? CollectionUtils.asSet((EnableSsl.Component[])annotationAttributes.get((Object)"components")) : components;
        components = components.isEmpty() ? Collections.singleton(EnableSsl.Component.ALL) : components;
        return components;
    }

    private void configureComponentCertificateAliases(AnnotationAttributes annotationAttributes, PropertiesBuilder gemfireProperties) {
        AnnotationAttributes[] componentCertificateAliases = annotationAttributes.getAnnotationArray("componentCertificateAliases");
        Arrays.stream(componentCertificateAliases).forEach(aliasAttributes -> {
            EnableSsl.Component component = (EnableSsl.Component)aliasAttributes.getEnum("component");
            String alias = aliasAttributes.getString("alias");
            gemfireProperties.setProperty(String.format("ssl-%s-alias", new Object[]{component}), alias);
        });
        Arrays.stream(EnableSsl.Component.values()).forEach(component -> {
            String propertyNameSuffix = String.format("certificate.alias.%s", component);
            Optional.ofNullable(this.resolveProperty(this.sslProperty(propertyNameSuffix), "")).filter(StringUtils::hasText).ifPresent(alias -> gemfireProperties.setProperty(String.format("ssl-%s-alias", component), StringUtils.trimWhitespace((String)alias)));
        });
    }
}

