/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.execution;

import java.lang.reflect.Method;
import java.util.stream.StreamSupport;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.data.gemfire.function.execution.DefaultFunctionExecutionMethodMetadata;
import org.springframework.data.gemfire.function.execution.FunctionExecutionMethodMetadata;
import org.springframework.data.gemfire.function.execution.GemfireFunctionOperations;
import org.springframework.data.gemfire.function.execution.MethodMetadata;
import org.springframework.data.gemfire.support.AbstractFactoryBeanSupport;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class GemfireFunctionProxyFactoryBean
extends AbstractFactoryBeanSupport<Object>
implements MethodInterceptor {
    private volatile boolean initialized;
    private final Class<?> functionExecutionInterface;
    private FunctionExecutionMethodMetadata<MethodMetadata> methodMetadata;
    private final GemfireFunctionOperations gemfireFunctionOperations;
    private volatile Object functionExecutionProxy;

    public GemfireFunctionProxyFactoryBean(Class<?> functionExecutionInterface, GemfireFunctionOperations gemfireFunctionOperations) {
        Assert.notNull(functionExecutionInterface, (String)"Function Execution Interface must not be null");
        Assert.isTrue((boolean)functionExecutionInterface.isInterface(), (String)String.format("Function Execution type [%s] must be an interface", functionExecutionInterface.getName()));
        this.functionExecutionInterface = functionExecutionInterface;
        this.gemfireFunctionOperations = gemfireFunctionOperations;
        this.methodMetadata = new DefaultFunctionExecutionMethodMetadata(functionExecutionInterface);
    }

    @Override
    public ClassLoader getBeanClassLoader() {
        ClassLoader beanClassLoader = super.getBeanClassLoader();
        return beanClassLoader != null ? beanClassLoader : ClassUtils.getDefaultClassLoader();
    }

    protected Class<?> getFunctionExecutionInterface() {
        return this.functionExecutionInterface;
    }

    protected FunctionExecutionMethodMetadata<MethodMetadata> getFunctionExecutionMethodMetadata() {
        return this.methodMetadata;
    }

    protected GemfireFunctionOperations getGemfireFunctionOperations() {
        return this.gemfireFunctionOperations;
    }

    public Object invoke(MethodInvocation invocation) {
        if (AopUtils.isToStringMethod((Method)invocation.getMethod())) {
            return String.format("Function Proxy for interface [%s]", this.getFunctionExecutionInterface().getName());
        }
        this.logDebug("Invoking method [{}]", invocation.getMethod().getName());
        Object result = this.invokeFunction(invocation.getMethod(), invocation.getArguments());
        return this.resolveResult(invocation, result);
    }

    protected Object invokeFunction(Method method, Object[] args) {
        String functionId = this.getFunctionExecutionMethodMetadata().getMethodMetadata(method).getFunctionId();
        return this.getGemfireFunctionOperations().execute(functionId, args);
    }

    protected Object resolveResult(MethodInvocation invocation, Object result) {
        return this.isIterable(result) && this.isNotInstanceOfFunctionReturnType(invocation, result) ? this.resolveSingleResultIfPossible((Iterable)result) : result;
    }

    protected Object resolveSingleResultIfPossible(Iterable<?> results) {
        return StreamSupport.stream(results.spliterator(), false).count() == 1L ? results.iterator().next() : results;
    }

    protected boolean isInstanceOfFunctionReturnType(MethodInvocation invocation, Object value) {
        return invocation.getMethod().getReturnType().isInstance(value);
    }

    protected boolean isNotInstanceOfFunctionReturnType(MethodInvocation invocation, Object value) {
        return !this.isInstanceOfFunctionReturnType(invocation, value);
    }

    protected boolean isIterable(Object value) {
        return value instanceof Iterable;
    }

    public Object getObject() throws Exception {
        if (this.functionExecutionProxy == null) {
            this.onInit();
            Assert.notNull((Object)this.functionExecutionProxy, (String)"Failed to initialize Function Proxy");
        }
        return this.functionExecutionProxy;
    }

    public Class<?> getObjectType() {
        return this.getFunctionExecutionInterface();
    }

    protected void onInit() {
        if (!this.initialized) {
            ProxyFactory proxyFactory = new ProxyFactory(this.getFunctionExecutionInterface(), (Interceptor)this);
            this.functionExecutionProxy = proxyFactory.getProxy(this.getBeanClassLoader());
            this.initialized = true;
        }
    }
}

