/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import java.util.Optional;
import org.apache.geode.cache.GemFireCache;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.data.gemfire.support.AbstractCachingCacheResolver;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BeanFactoryCacheResolver
extends AbstractCachingCacheResolver<GemFireCache>
implements BeanFactoryAware {
    private BeanFactory beanFactory;
    private String cacheBeanName;

    public BeanFactoryCacheResolver(BeanFactory beanFactory) {
        this.setBeanFactory(beanFactory);
    }

    public final void setBeanFactory(@NonNull BeanFactory beanFactory) throws BeansException {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        this.beanFactory = beanFactory;
    }

    @NonNull
    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setCacheBeanName(String cacheBeanName) {
        this.cacheBeanName = cacheBeanName;
    }

    public Optional<String> getCacheBeanName() {
        return Optional.ofNullable(this.cacheBeanName).filter(StringUtils::hasText);
    }

    @Override
    protected GemFireCache doResolve() {
        return this.getCacheBeanName().map(cacheBeanName -> (GemFireCache)this.getBeanFactory().getBean(cacheBeanName, GemFireCache.class)).orElse((GemFireCache)this.getBeanFactory().getBean(GemFireCache.class));
    }
}

