/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.util;

import java.util.Optional;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientCacheFactory;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.springframework.data.gemfire.util.DistributedSystemUtils;
import org.springframework.util.StringUtils;

public abstract class CacheUtils
extends DistributedSystemUtils {
    public static final String DEFAULT_POOL_NAME = "DEFAULT";

    public static boolean isClient(GemFireCache cache) {
        boolean client = cache instanceof ClientCache;
        if (cache instanceof GemFireCacheImpl) {
            client &= ((GemFireCacheImpl)cache).isClient();
        }
        return client;
    }

    public static boolean isDefaultPool(Pool pool) {
        return Optional.ofNullable(pool).map(Pool::getName).filter(CacheUtils::isDefaultPool).isPresent();
    }

    public static boolean isNotDefaultPool(Pool pool) {
        return !CacheUtils.isDefaultPool(pool);
    }

    public static boolean isDefaultPool(String poolName) {
        return DEFAULT_POOL_NAME.equals(poolName);
    }

    public static boolean isNotDefaultPool(String poolName) {
        return !CacheUtils.isDefaultPool(poolName);
    }

    public static boolean isDurable(ClientCache clientCache) {
        return Optional.ofNullable(clientCache).map(DistributedSystemUtils::getDistributedSystem).filter(DistributedSystem::isConnected).map(DistributedSystem::getProperties).map(properties -> properties.getProperty(DURABLE_CLIENT_ID_PROPERTY_NAME, null)).filter(StringUtils::hasText).isPresent();
    }

    public static boolean isPeer(GemFireCache cache) {
        boolean peer = cache instanceof Cache;
        if (cache instanceof GemFireCacheImpl) {
            peer &= !((GemFireCacheImpl)cache).isClient();
        }
        return peer;
    }

    public static boolean close() {
        return CacheUtils.close(CacheUtils.resolveGemFireCache());
    }

    public static boolean close(GemFireCache gemfireCache) {
        return CacheUtils.close(gemfireCache, () -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean close(GemFireCache gemfireCache, Runnable shutdownHook) {
        try {
            gemfireCache.close();
            boolean bl = true;
            return bl;
        }
        catch (Exception ignore) {
            boolean bl = false;
            return bl;
        }
        finally {
            Optional.ofNullable(shutdownHook).ifPresent(Runnable::run);
        }
    }

    public static boolean closeCache() {
        try {
            CacheFactory.getAnyInstance().close();
            return true;
        }
        catch (Exception ignore) {
            return false;
        }
    }

    public static boolean closeClientCache() {
        try {
            ClientCacheFactory.getAnyInstance().close();
            return true;
        }
        catch (Exception ignore) {
            return false;
        }
    }

    public static Cache getCache() {
        try {
            return CacheFactory.getAnyInstance();
        }
        catch (CacheClosedException ignore) {
            return null;
        }
    }

    public static ClientCache getClientCache() {
        try {
            return ClientCacheFactory.getAnyInstance();
        }
        catch (IllegalStateException | CacheClosedException ignore) {
            return null;
        }
    }

    public static GemFireCache resolveGemFireCache() {
        return Optional.ofNullable(CacheUtils.getClientCache()).orElseGet(CacheUtils::getCache);
    }
}

