/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.config.namespace;

import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.hadoop.config.namespace.AbstractGenericOptionsParser;
import org.springframework.data.hadoop.config.namespace.NamespaceUtils;
import org.springframework.data.hadoop.mapreduce.JarRunner;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class JarRunnerParser
extends AbstractGenericOptionsParser {
    protected Class<?> getBeanClass(Element element) {
        return JarRunner.class;
    }

    @Override
    protected boolean isEligibleAttribute(String attributeName) {
        return !"pre-action".equals(attributeName) && !"post-action".equals(attributeName) && super.isEligibleAttribute(attributeName);
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        JarRunnerParser.parseJarDefinition(element, parserContext, builder);
    }

    public static void parseJarDefinition(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List list = DomUtils.getChildElements((Element)element);
        ManagedList args = new ManagedList();
        for (Element child : list) {
            if (!"arg".equals(child.getLocalName())) continue;
            args.add((Object)child.getAttribute("value").trim());
        }
        builder.addPropertyValue("arguments", (Object)args);
        NamespaceUtils.setCSVReferenceProperty(element, builder, "pre-action", "preAction");
        NamespaceUtils.setCSVReferenceProperty(element, builder, "post-action", "postAction");
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }
}

