/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.convert.threeten;

import jakarta.persistence.AttributeConverter;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.Jsr310Converters;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class Jsr310JpaConverters {

    @WritingConverter
    static enum InstantToTimestampConverter implements Converter<Instant, Timestamp>
    {
        INSTANCE;


        @NonNull
        public Timestamp convert(Instant source) {
            return Timestamp.from(source);
        }
    }

    @ReadingConverter
    static enum TimestampToInstantConverter implements Converter<Timestamp, Instant>
    {
        INSTANCE;


        @NonNull
        public Instant convert(Timestamp source) {
            return source.toInstant();
        }
    }

    @jakarta.persistence.Converter(autoApply=true)
    public static class ZoneIdConverter
    implements AttributeConverter<ZoneId, String> {
        @Nullable
        public String convertToDatabaseColumn(ZoneId zoneId) {
            return zoneId == null ? null : Jsr310Converters.ZoneIdToStringConverter.INSTANCE.convert(zoneId);
        }

        @Nullable
        public ZoneId convertToEntityAttribute(String zoneId) {
            return zoneId == null ? null : Jsr310Converters.StringToZoneIdConverter.INSTANCE.convert(zoneId);
        }
    }

    @jakarta.persistence.Converter(autoApply=true)
    public static class InstantConverter
    implements AttributeConverter<Instant, Timestamp> {
        @Nullable
        public Timestamp convertToDatabaseColumn(Instant instant) {
            return instant == null ? null : InstantToTimestampConverter.INSTANCE.convert(instant);
        }

        @Nullable
        public Instant convertToEntityAttribute(Timestamp timestamp) {
            return timestamp == null ? null : TimestampToInstantConverter.INSTANCE.convert(timestamp);
        }
    }

    @jakarta.persistence.Converter(autoApply=true)
    public static class LocalDateTimeConverter
    implements AttributeConverter<LocalDateTime, Date> {
        @Nullable
        public Date convertToDatabaseColumn(LocalDateTime date) {
            return date == null ? null : Jsr310Converters.LocalDateTimeToDateConverter.INSTANCE.convert(date);
        }

        @Nullable
        public LocalDateTime convertToEntityAttribute(Date date) {
            return date == null ? null : Jsr310Converters.DateToLocalDateTimeConverter.INSTANCE.convert(date);
        }
    }

    @jakarta.persistence.Converter(autoApply=true)
    public static class LocalTimeConverter
    implements AttributeConverter<LocalTime, Date> {
        @Nullable
        public Date convertToDatabaseColumn(LocalTime time) {
            return time == null ? null : Jsr310Converters.LocalTimeToDateConverter.INSTANCE.convert(time);
        }

        @Nullable
        public LocalTime convertToEntityAttribute(Date date) {
            return date == null ? null : Jsr310Converters.DateToLocalTimeConverter.INSTANCE.convert(date);
        }
    }

    @jakarta.persistence.Converter(autoApply=true)
    public static class LocalDateConverter
    implements AttributeConverter<LocalDate, Date> {
        @Nullable
        public Date convertToDatabaseColumn(LocalDate date) {
            return date == null ? null : Jsr310Converters.LocalDateToDateConverter.INSTANCE.convert(date);
        }

        @Nullable
        public LocalDate convertToEntityAttribute(Date date) {
            return date == null ? null : Jsr310Converters.DateToLocalDateConverter.INSTANCE.convert(date);
        }
    }
}

