/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.query.Order;
import org.springframework.data.mongodb.repository.query.PartTreeMongoQuery;
import org.springframework.data.mongodb.repository.query.QueryUtils;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.core.support.QueryCreationListener;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IndexEnsuringQueryCreationListener
implements QueryCreationListener<PartTreeMongoQuery> {
    private static final Set<Part.Type> GEOSPATIAL_TYPES = new HashSet<Part.Type>(Arrays.asList(Part.Type.NEAR, Part.Type.WITHIN));
    private static final Logger LOG = LoggerFactory.getLogger(IndexEnsuringQueryCreationListener.class);
    private final MongoOperations operations;

    public IndexEnsuringQueryCreationListener(MongoOperations operations) {
        Assert.notNull((Object)operations);
        this.operations = operations;
    }

    public void onCreation(PartTreeMongoQuery query) {
        PartTree tree = query.getTree();
        Index index = new Index();
        index.named(query.getQueryMethod().getName());
        Sort sort = tree.getSort();
        for (Part part : tree.getParts()) {
            if (GEOSPATIAL_TYPES.contains(part.getType())) {
                return;
            }
            String property = part.getProperty().toDotPath();
            Order order = IndexEnsuringQueryCreationListener.toOrder(sort, property);
            index.on(property, order);
        }
        if (sort != null) {
            for (Sort.Order order : sort) {
                index.on(order.getProperty(), QueryUtils.toOrder(order));
            }
        }
        EntityMetadata metadata = query.getQueryMethod().getEntityInformation();
        this.operations.indexOps(metadata.getCollectionName()).ensureIndex(index);
        LOG.debug(String.format("Created %s!", index));
    }

    private static Order toOrder(Sort sort, String property) {
        if (sort == null) {
            return Order.DESCENDING;
        }
        Sort.Order order = sort.getOrderFor(property);
        return order == null ? Order.DESCENDING : (order.isAscending() ? Order.ASCENDING : Order.DESCENDING);
    }
}

