/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexDefinition;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.index.GeoSpatialIndexed;
import org.springframework.data.mongodb.core.index.GeospatialIndex;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexDirection;
import org.springframework.data.mongodb.core.index.IndexResolver;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.index.TextIndexDefinition;
import org.springframework.data.mongodb.core.index.TextIndexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MongoPersistentEntityIndexResolver
implements IndexResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoPersistentEntityIndexResolver.class);
    private final MongoMappingContext mappingContext;

    public MongoPersistentEntityIndexResolver(MongoMappingContext mappingContext) {
        Assert.notNull((Object)((Object)mappingContext), (String)"Mapping context must not be null in order to resolve index definitions");
        this.mappingContext = mappingContext;
    }

    @Override
    public Iterable<? extends IndexDefinitionHolder> resolveIndexFor(TypeInformation<?> typeInformation) {
        return this.resolveIndexForEntity((MongoPersistentEntity)this.mappingContext.getPersistentEntity(typeInformation));
    }

    public List<IndexDefinitionHolder> resolveIndexForEntity(final MongoPersistentEntity<?> root) {
        Assert.notNull(root, (String)"Index cannot be resolved for given 'null' entity.");
        Document document = (Document)root.findAnnotation(Document.class);
        Assert.notNull((Object)document, (String)"Given entity is not collection root.");
        final ArrayList<IndexDefinitionHolder> indexInformation = new ArrayList<IndexDefinitionHolder>();
        indexInformation.addAll(this.potentiallyCreateCompoundIndexDefinitions("", root.getCollection(), root));
        indexInformation.addAll(this.potentiallyCreateTextIndexDefinition(root));
        final CycleGuard guard = new CycleGuard();
        root.doWithProperties((PropertyHandler)new PropertyHandler<MongoPersistentProperty>(){

            public void doWithPersistentProperty(MongoPersistentProperty persistentProperty) {
                try {
                    IndexDefinitionHolder indexDefinitionHolder;
                    if (persistentProperty.isEntity()) {
                        indexInformation.addAll(MongoPersistentEntityIndexResolver.this.resolveIndexForClass(persistentProperty.getActualType(), persistentProperty.getFieldName(), root.getCollection(), guard));
                    }
                    if ((indexDefinitionHolder = MongoPersistentEntityIndexResolver.this.createIndexDefinitionHolderForProperty(persistentProperty.getFieldName(), root.getCollection(), persistentProperty)) != null) {
                        indexInformation.add(indexDefinitionHolder);
                    }
                }
                catch (CyclicPropertyReferenceException e) {
                    LOGGER.info(e.getMessage());
                }
            }
        });
        return indexInformation;
    }

    private List<IndexDefinitionHolder> resolveIndexForClass(Class<?> type, final String path, final String collection, final CycleGuard guard) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(type);
        final ArrayList<IndexDefinitionHolder> indexInformation = new ArrayList<IndexDefinitionHolder>();
        indexInformation.addAll(this.potentiallyCreateCompoundIndexDefinitions(path, collection, entity));
        entity.doWithProperties((PropertyHandler)new PropertyHandler<MongoPersistentProperty>(){

            public void doWithPersistentProperty(MongoPersistentProperty persistentProperty) {
                IndexDefinitionHolder indexDefinitionHolder;
                String propertyDotPath = (StringUtils.hasText((String)path) ? path + "." : "") + persistentProperty.getFieldName();
                guard.protect(persistentProperty, path);
                if (persistentProperty.isEntity()) {
                    try {
                        indexInformation.addAll(MongoPersistentEntityIndexResolver.this.resolveIndexForClass(persistentProperty.getActualType(), propertyDotPath, collection, guard));
                    }
                    catch (CyclicPropertyReferenceException e) {
                        LOGGER.info(e.getMessage());
                    }
                }
                if ((indexDefinitionHolder = MongoPersistentEntityIndexResolver.this.createIndexDefinitionHolderForProperty(propertyDotPath, collection, persistentProperty)) != null) {
                    indexInformation.add(indexDefinitionHolder);
                }
            }
        });
        return indexInformation;
    }

    private IndexDefinitionHolder createIndexDefinitionHolderForProperty(String dotPath, String collection, MongoPersistentProperty persistentProperty) {
        if (persistentProperty.isAnnotationPresent(Indexed.class)) {
            return this.createIndexDefinition(dotPath, collection, persistentProperty);
        }
        if (persistentProperty.isAnnotationPresent(GeoSpatialIndexed.class)) {
            return this.createGeoSpatialIndexDefinition(dotPath, collection, persistentProperty);
        }
        return null;
    }

    private List<IndexDefinitionHolder> potentiallyCreateCompoundIndexDefinitions(String dotPath, String collection, MongoPersistentEntity<?> entity) {
        if (entity.findAnnotation(CompoundIndexes.class) == null && entity.findAnnotation(CompoundIndex.class) == null) {
            return Collections.emptyList();
        }
        return this.createCompoundIndexDefinitions(dotPath, collection, entity);
    }

    private Collection<? extends IndexDefinitionHolder> potentiallyCreateTextIndexDefinition(MongoPersistentEntity<?> root) {
        TextIndexDefinition.TextIndexDefinitionBuilder indexDefinitionBuilder = new TextIndexDefinition.TextIndexDefinitionBuilder().named(root.getType().getSimpleName() + "_TextIndex");
        if (StringUtils.hasText((String)root.getLanguage())) {
            indexDefinitionBuilder.withDefaultLanguage(root.getLanguage());
        }
        try {
            this.appendTextIndexInformation("", indexDefinitionBuilder, root, new TextIndexIncludeOptions(TextIndexIncludeOptions.IncludeStrategy.DEFAULT), new CycleGuard());
        }
        catch (CyclicPropertyReferenceException e) {
            LOGGER.info(e.getMessage());
        }
        TextIndexDefinition indexDefinition = indexDefinitionBuilder.build();
        if (!indexDefinition.hasFieldSpec()) {
            return Collections.emptyList();
        }
        IndexDefinitionHolder holder = new IndexDefinitionHolder("", indexDefinition, root.getCollection());
        return Collections.singletonList(holder);
    }

    private void appendTextIndexInformation(final String dotPath, final TextIndexDefinition.TextIndexDefinitionBuilder indexDefinitionBuilder, final MongoPersistentEntity<?> entity, final TextIndexIncludeOptions includeOptions, final CycleGuard guard) {
        entity.doWithProperties((PropertyHandler)new PropertyHandler<MongoPersistentProperty>(){

            public void doWithPersistentProperty(MongoPersistentProperty persistentProperty) {
                guard.protect(persistentProperty, dotPath);
                if (persistentProperty.isExplicitLanguageProperty() && !StringUtils.hasText((String)dotPath)) {
                    indexDefinitionBuilder.withLanguageOverride(persistentProperty.getFieldName());
                }
                TextIndexed indexed = (TextIndexed)persistentProperty.findAnnotation(TextIndexed.class);
                if (includeOptions.isForce() || indexed != null || persistentProperty.isEntity()) {
                    String propertyDotPath = (StringUtils.hasText((String)dotPath) ? dotPath + "." : "") + persistentProperty.getFieldName();
                    Float weight = Float.valueOf(indexed != null ? indexed.weight() : (includeOptions.getParentFieldSpec() != null ? includeOptions.getParentFieldSpec().getWeight().floatValue() : 1.0f));
                    if (persistentProperty.isEntity()) {
                        TextIndexIncludeOptions optionsForNestedType = includeOptions;
                        if (!TextIndexIncludeOptions.IncludeStrategy.FORCE.equals((Object)includeOptions.getStrategy()) && indexed != null) {
                            optionsForNestedType = new TextIndexIncludeOptions(TextIndexIncludeOptions.IncludeStrategy.FORCE, new TextIndexDefinition.TextIndexedFieldSpec(propertyDotPath, weight));
                        }
                        try {
                            MongoPersistentEntityIndexResolver.this.appendTextIndexInformation(propertyDotPath, indexDefinitionBuilder, (MongoPersistentEntity)MongoPersistentEntityIndexResolver.this.mappingContext.getPersistentEntity(persistentProperty.getActualType()), optionsForNestedType, guard);
                        }
                        catch (CyclicPropertyReferenceException e) {
                            LOGGER.info(e.getMessage(), (Throwable)e);
                        }
                        catch (InvalidDataAccessApiUsageException e) {
                            LOGGER.info(String.format("Potentially invalid index structure discovered. Breaking operation for %s.", entity.getName()), (Throwable)e);
                        }
                    } else if (includeOptions.isForce() || indexed != null) {
                        indexDefinitionBuilder.onField(propertyDotPath, weight);
                    }
                }
            }
        });
    }

    protected List<IndexDefinitionHolder> createCompoundIndexDefinitions(String dotPath, String fallbackCollection, MongoPersistentEntity<?> entity) {
        CompoundIndex index;
        ArrayList<IndexDefinitionHolder> indexDefinitions = new ArrayList<IndexDefinitionHolder>();
        CompoundIndexes indexes = (CompoundIndexes)entity.findAnnotation(CompoundIndexes.class);
        if (indexes != null) {
            for (CompoundIndex index2 : indexes.value()) {
                indexDefinitions.add(this.createCompoundIndexDefinition(dotPath, fallbackCollection, index2, entity));
            }
        }
        if ((index = (CompoundIndex)entity.findAnnotation(CompoundIndex.class)) != null) {
            indexDefinitions.add(this.createCompoundIndexDefinition(dotPath, fallbackCollection, index, entity));
        }
        return indexDefinitions;
    }

    protected IndexDefinitionHolder createCompoundIndexDefinition(String dotPath, String fallbackCollection, CompoundIndex index, MongoPersistentEntity<?> entity) {
        CompoundIndexDefinition indexDefinition = new CompoundIndexDefinition(this.resolveCompoundIndexKeyFromStringDefinition(dotPath, index.def()));
        if (!index.useGeneratedName()) {
            indexDefinition.named(this.pathAwareIndexName(index.name(), dotPath, null));
        }
        if (index.unique()) {
            indexDefinition.unique(index.dropDups() ? Index.Duplicates.DROP : Index.Duplicates.RETAIN);
        }
        if (index.sparse()) {
            indexDefinition.sparse();
        }
        if (index.background()) {
            indexDefinition.background();
        }
        String collection = StringUtils.hasText((String)index.collection()) ? index.collection() : fallbackCollection;
        return new IndexDefinitionHolder(dotPath, indexDefinition, collection);
    }

    private DBObject resolveCompoundIndexKeyFromStringDefinition(String dotPath, String keyDefinitionString) {
        if (!StringUtils.hasText((String)dotPath) && !StringUtils.hasText((String)keyDefinitionString)) {
            throw new InvalidDataAccessApiUsageException("Cannot create index on root level for empty keys.");
        }
        if (!StringUtils.hasText((String)keyDefinitionString)) {
            return new BasicDBObject(dotPath, (Object)1);
        }
        DBObject dbo = (DBObject)JSON.parse((String)keyDefinitionString);
        if (!StringUtils.hasText((String)dotPath)) {
            return dbo;
        }
        BasicDBObjectBuilder dboBuilder = new BasicDBObjectBuilder();
        for (String key : dbo.keySet()) {
            dboBuilder.add(dotPath + "." + key, dbo.get(key));
        }
        return dboBuilder.get();
    }

    protected IndexDefinitionHolder createIndexDefinition(String dotPath, String fallbackCollection, MongoPersistentProperty persitentProperty) {
        Indexed index = (Indexed)persitentProperty.findAnnotation(Indexed.class);
        String collection = StringUtils.hasText((String)index.collection()) ? index.collection() : fallbackCollection;
        Index indexDefinition = new Index().on(dotPath, IndexDirection.ASCENDING.equals((Object)index.direction()) ? Sort.Direction.ASC : Sort.Direction.DESC);
        if (!index.useGeneratedName()) {
            indexDefinition.named(this.pathAwareIndexName(index.name(), dotPath, persitentProperty));
        }
        if (index.unique()) {
            indexDefinition.unique(index.dropDups() ? Index.Duplicates.DROP : Index.Duplicates.RETAIN);
        }
        if (index.sparse()) {
            indexDefinition.sparse();
        }
        if (index.background()) {
            indexDefinition.background();
        }
        if (index.expireAfterSeconds() >= 0) {
            indexDefinition.expire(index.expireAfterSeconds(), TimeUnit.SECONDS);
        }
        return new IndexDefinitionHolder(dotPath, indexDefinition, collection);
    }

    protected IndexDefinitionHolder createGeoSpatialIndexDefinition(String dotPath, String fallbackCollection, MongoPersistentProperty persistentProperty) {
        GeoSpatialIndexed index = (GeoSpatialIndexed)persistentProperty.findAnnotation(GeoSpatialIndexed.class);
        String collection = StringUtils.hasText((String)index.collection()) ? index.collection() : fallbackCollection;
        GeospatialIndex indexDefinition = new GeospatialIndex(dotPath);
        indexDefinition.withBits(index.bits());
        indexDefinition.withMin(index.min()).withMax(index.max());
        if (!index.useGeneratedName()) {
            indexDefinition.named(this.pathAwareIndexName(index.name(), dotPath, persistentProperty));
        }
        indexDefinition.typed(index.type()).withBucketSize(index.bucketSize()).withAdditionalField(index.additionalField());
        return new IndexDefinitionHolder(dotPath, indexDefinition, collection);
    }

    private String pathAwareIndexName(String indexName, String dotPath, MongoPersistentProperty property) {
        String nameToUse;
        String string = nameToUse = StringUtils.hasText((String)indexName) ? indexName : "";
        if (!StringUtils.hasText((String)dotPath) || property != null && dotPath.equals(property.getFieldName())) {
            return StringUtils.hasText((String)nameToUse) ? nameToUse : dotPath;
        }
        if (StringUtils.hasText((String)dotPath)) {
            nameToUse = StringUtils.hasText((String)nameToUse) ? (property != null ? dotPath.replace("." + property.getFieldName(), "") : dotPath) + "." + nameToUse : dotPath;
        }
        return nameToUse;
    }

    static class TextIndexIncludeOptions {
        private final IncludeStrategy strategy;
        private final TextIndexDefinition.TextIndexedFieldSpec parentFieldSpec;

        public TextIndexIncludeOptions(IncludeStrategy strategy, TextIndexDefinition.TextIndexedFieldSpec parentFieldSpec) {
            this.strategy = strategy;
            this.parentFieldSpec = parentFieldSpec;
        }

        public TextIndexIncludeOptions(IncludeStrategy strategy) {
            this(strategy, null);
        }

        public IncludeStrategy getStrategy() {
            return this.strategy;
        }

        public TextIndexDefinition.TextIndexedFieldSpec getParentFieldSpec() {
            return this.parentFieldSpec;
        }

        public boolean isForce() {
            return IncludeStrategy.FORCE.equals((Object)this.strategy);
        }

        static enum IncludeStrategy {
            FORCE,
            DEFAULT;

        }
    }

    public static class IndexDefinitionHolder
    implements IndexDefinition {
        private final String path;
        private final IndexDefinition indexDefinition;
        private final String collection;

        public IndexDefinitionHolder(String path, IndexDefinition definition, String collection) {
            this.path = path;
            this.indexDefinition = definition;
            this.collection = collection;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getPath() {
            return this.path;
        }

        public IndexDefinition getIndexDefinition() {
            return this.indexDefinition;
        }

        @Override
        public DBObject getIndexKeys() {
            return this.indexDefinition.getIndexKeys();
        }

        @Override
        public DBObject getIndexOptions() {
            return this.indexDefinition.getIndexOptions();
        }
    }

    public static class CyclicPropertyReferenceException
    extends RuntimeException {
        private static final long serialVersionUID = -3762979307658772277L;
        private final String propertyName;
        private final Class<?> type;
        private final String dotPath;

        public CyclicPropertyReferenceException(String propertyName, Class<?> type, String dotPath) {
            this.propertyName = propertyName;
            this.type = type;
            this.dotPath = dotPath;
        }

        @Override
        public String getMessage() {
            return String.format("Found cycle for field '%s' in type '%s' for path '%s'", this.propertyName, this.type != null ? this.type.getSimpleName() : "unknown", this.dotPath);
        }
    }

    static class CycleGuard {
        private final Map<String, List<Path>> propertyTypeMap = new LinkedHashMap<String, List<Path>>();

        CycleGuard() {
        }

        void protect(MongoPersistentProperty property, String path) throws CyclicPropertyReferenceException {
            String propertyTypeKey = this.createMapKey(property);
            if (this.propertyTypeMap.containsKey(propertyTypeKey)) {
                List<Path> paths = this.propertyTypeMap.get(propertyTypeKey);
                for (Path existingPath : paths) {
                    if (!existingPath.cycles(property, path) || !property.isEntity()) continue;
                    paths.add(new Path(property, path));
                    throw new CyclicPropertyReferenceException(property.getFieldName(), property.getOwner().getType(), existingPath.getPath());
                }
                paths.add(new Path(property, path));
            } else {
                ArrayList<Path> paths = new ArrayList<Path>();
                paths.add(new Path(property, path));
                this.propertyTypeMap.put(propertyTypeKey, paths);
            }
        }

        private String createMapKey(MongoPersistentProperty property) {
            return property.getOwner().getType().getSimpleName() + ":" + property.getFieldName();
        }

        static class Path {
            private final MongoPersistentProperty property;
            private final String path;

            Path(MongoPersistentProperty property, String path) {
                this.property = property;
                this.path = path;
            }

            public String getPath() {
                return this.path;
            }

            boolean cycles(MongoPersistentProperty property, String path) {
                if (!property.getOwner().equals(this.property.getOwner())) {
                    return false;
                }
                return path.equals(this.path) || path.contains(this.path + ".") || path.contains("." + this.path);
            }
        }
    }
}

