/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.aggregation.AbstractAggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.AggregationUtils;
import org.springframework.data.mongodb.core.aggregation.AggregationVariable;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.NestedDelegatingExpressionAggregationOperationContext;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;

public class ArrayOperators {
    public static ArrayOperatorFactory arrayOf(String fieldReference) {
        return new ArrayOperatorFactory(fieldReference);
    }

    public static ArrayOperatorFactory arrayOf(AggregationExpression expression) {
        return new ArrayOperatorFactory(expression);
    }

    public static ArrayOperatorFactory arrayOf(Collection<?> values) {
        return new ArrayOperatorFactory(values);
    }

    public static class ArrayOperatorFactory {
        private final @Nullable String fieldReference;
        private final @Nullable AggregationExpression expression;
        private final @Nullable Collection<?> values;

        public ArrayOperatorFactory(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            this.fieldReference = fieldReference;
            this.expression = null;
            this.values = null;
        }

        public ArrayOperatorFactory(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            this.fieldReference = null;
            this.expression = expression;
            this.values = null;
        }

        public ArrayOperatorFactory(Collection<?> values) {
            Assert.notNull(values, (String)"Values must not be null");
            this.fieldReference = null;
            this.expression = null;
            this.values = values;
        }

        public ArrayElemAt elementAt(int position) {
            return this.createArrayElemAt().elementAt(position);
        }

        public ArrayElemAt elementAt(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return this.createArrayElemAt().elementAt(expression);
        }

        public ArrayElemAt elementAt(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return this.createArrayElemAt().elementAt(fieldReference);
        }

        private ArrayElemAt createArrayElemAt() {
            if (this.usesFieldRef()) {
                return ArrayElemAt.arrayOf(this.fieldReference);
            }
            return this.usesExpression() ? ArrayElemAt.arrayOf(this.expression) : ArrayElemAt.arrayOf(this.values);
        }

        public ConcatArrays concat(String arrayFieldReference) {
            Assert.notNull((Object)arrayFieldReference, (String)"ArrayFieldReference must not be null");
            return this.createConcatArrays().concat(arrayFieldReference);
        }

        public ConcatArrays concat(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return this.createConcatArrays().concat(expression);
        }

        private ConcatArrays createConcatArrays() {
            if (this.usesFieldRef()) {
                return ConcatArrays.arrayOf(this.fieldReference);
            }
            return this.usesExpression() ? ConcatArrays.arrayOf(this.expression) : ConcatArrays.arrayOf(this.values);
        }

        public Filter.AsBuilder filter() {
            if (this.usesFieldRef()) {
                return Filter.filter(this.fieldReference);
            }
            if (this.usesExpression()) {
                return Filter.filter(this.expression);
            }
            Assert.state((this.values != null ? 1 : 0) != 0, (String)"Values must not be null");
            return Filter.filter(new ArrayList(this.values));
        }

        public IsArray isArray() {
            Assert.state((this.values == null ? 1 : 0) != 0, (String)"Does it make sense to call isArray on an array; Maybe just skip it");
            return this.usesFieldRef() ? IsArray.isArray(this.fieldReference) : IsArray.isArray(this.expression);
        }

        public Size length() {
            if (this.usesFieldRef()) {
                return Size.lengthOfArray(this.fieldReference);
            }
            return this.usesExpression() ? Size.lengthOfArray(this.expression) : Size.lengthOfArray(this.values);
        }

        public Slice slice() {
            if (this.usesFieldRef()) {
                return Slice.sliceArrayOf(this.fieldReference);
            }
            return this.usesExpression() ? Slice.sliceArrayOf(this.expression) : Slice.sliceArrayOf(this.values);
        }

        public IndexOfArray indexOf(Object value) {
            if (this.usesFieldRef()) {
                return IndexOfArray.arrayOf(this.fieldReference).indexOf(value);
            }
            return this.usesExpression() ? IndexOfArray.arrayOf(this.expression).indexOf(value) : IndexOfArray.arrayOf(this.values).indexOf(value);
        }

        public ReverseArray reverse() {
            if (this.usesFieldRef()) {
                return ReverseArray.reverseArrayOf(this.fieldReference);
            }
            return this.usesExpression() ? ReverseArray.reverseArrayOf(this.expression) : ReverseArray.reverseArrayOf(Collections.singletonList(this.values));
        }

        public ReduceInitialValueBuilder reduce(AggregationExpression expression) {
            return initialValue -> (this.usesFieldRef() ? Reduce.arrayOf(this.fieldReference) : Reduce.arrayOf(this.expression)).withInitialValue(initialValue).reduce(expression);
        }

        public ReduceInitialValueBuilder reduce(Reduce.PropertyExpression ... expressions) {
            return initialValue -> (this.usesFieldRef() ? Reduce.arrayOf(this.fieldReference) : Reduce.arrayOf(this.expression)).withInitialValue(initialValue).reduce(expressions);
        }

        public SortArray sort(Sort sort) {
            if (this.usesFieldRef()) {
                return SortArray.sortArrayOf(this.fieldReference).by(sort);
            }
            return (this.usesExpression() ? SortArray.sortArrayOf(this.expression) : SortArray.sortArray(this.values)).by(sort);
        }

        public SortArray sort(Sort.Direction direction) {
            if (this.usesFieldRef()) {
                return SortArray.sortArrayOf(this.fieldReference).direction(direction);
            }
            return (this.usesExpression() ? SortArray.sortArrayOf(this.expression) : SortArray.sortArray(this.values)).direction(direction);
        }

        public Zip zipWith(Object ... arrays) {
            if (this.usesFieldRef()) {
                return Zip.arrayOf(this.fieldReference).zip(arrays);
            }
            return (this.usesExpression() ? Zip.arrayOf(this.expression) : Zip.arrayOf(this.values)).zip(arrays);
        }

        public In containsValue(Object value) {
            if (this.usesFieldRef()) {
                return In.arrayOf(this.fieldReference).containsValue(value);
            }
            return (this.usesExpression() ? In.arrayOf(this.expression) : In.arrayOf(this.values)).containsValue(value);
        }

        public ArrayToObject toObject() {
            if (this.usesFieldRef()) {
                return ArrayToObject.arrayValueOfToObject(this.fieldReference);
            }
            return this.usesExpression() ? ArrayToObject.arrayValueOfToObject(this.expression) : ArrayToObject.arrayToObject(this.values);
        }

        public First first() {
            if (this.usesFieldRef()) {
                return First.firstOf(this.fieldReference);
            }
            return this.usesExpression() ? First.firstOf(this.expression) : First.first(this.values);
        }

        public Last last() {
            if (this.usesFieldRef()) {
                return Last.lastOf(this.fieldReference);
            }
            return this.usesExpression() ? Last.lastOf(this.expression) : Last.last(this.values);
        }

        private boolean usesFieldRef() {
            return this.fieldReference != null;
        }

        private boolean usesExpression() {
            return this.expression != null;
        }

        public static interface ReduceInitialValueBuilder {
            public Reduce startingWith(Object var1);
        }
    }

    public static class SortArray
    extends AbstractAggregationExpression {
        private SortArray(Object value) {
            super(value);
        }

        public static SortArray sortArray(Object array) {
            return new SortArray(Collections.singletonMap("input", array));
        }

        public static SortArray sortArrayOf(String fieldReference) {
            return SortArray.sortArray(Fields.field(fieldReference));
        }

        public static SortArray sortArrayOf(AggregationExpression expression) {
            return SortArray.sortArray(expression);
        }

        @Contract(value="_ -> new")
        public SortArray by(Sort sort) {
            return new SortArray(this.append("sortBy", sort));
        }

        public SortArray direction(Sort.Direction direction) {
            return new SortArray(this.append("sortBy", direction.isAscending() ? 1 : -1));
        }

        public SortArray byValueAscending() {
            return this.direction(Sort.Direction.ASC);
        }

        public SortArray byValueDescending() {
            return this.direction(Sort.Direction.DESC);
        }

        @Override
        protected String getMongoMethod() {
            return "$sortArray";
        }
    }

    public static class Last
    extends AbstractAggregationExpression {
        private Last(Object value) {
            super(value);
        }

        public static Last last(Object array) {
            return new Last(array);
        }

        public static Last lastOf(String fieldReference) {
            return new Last(Fields.field(fieldReference));
        }

        public static Last lastOf(AggregationExpression expression) {
            return new Last(expression);
        }

        @Override
        protected String getMongoMethod() {
            return "$last";
        }
    }

    public static class First
    extends AbstractAggregationExpression {
        private First(Object value) {
            super(value);
        }

        public static First first(Object array) {
            return new First(array);
        }

        public static First firstOf(String fieldReference) {
            return new First(Fields.field(fieldReference));
        }

        public static First firstOf(AggregationExpression expression) {
            return new First(expression);
        }

        @Override
        protected String getMongoMethod() {
            return "$first";
        }
    }

    public static class ArrayToObject
    extends AbstractAggregationExpression {
        private ArrayToObject(Object value) {
            super(value);
        }

        public static ArrayToObject arrayToObject(Object array) {
            return new ArrayToObject(array);
        }

        public static ArrayToObject arrayValueOfToObject(String fieldReference) {
            return new ArrayToObject(Fields.field(fieldReference));
        }

        public static ArrayToObject arrayValueOfToObject(AggregationExpression expression) {
            return new ArrayToObject(expression);
        }

        @Override
        protected String getMongoMethod() {
            return "$arrayToObject";
        }
    }

    public static class In
    extends AbstractAggregationExpression {
        private In(List<Object> values) {
            super(values);
        }

        @Override
        protected String getMongoMethod() {
            return "$in";
        }

        public static InBuilder arrayOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return value -> {
                Assert.notNull((Object)value, (String)"Value must not be null");
                return new In(Arrays.asList(value, Fields.field(fieldReference)));
            };
        }

        public static InBuilder arrayOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return value -> {
                Assert.notNull((Object)value, (String)"Value must not be null");
                return new In(Arrays.asList(value, expression));
            };
        }

        public static InBuilder arrayOf(Collection<?> values) {
            Assert.notNull(values, (String)"Values must not be null");
            return value -> {
                Assert.notNull((Object)value, (String)"Value must not be null");
                return new In(Arrays.asList(value, values));
            };
        }

        public static interface InBuilder {
            public In containsValue(Object var1);
        }
    }

    public static class Zip
    extends AbstractAggregationExpression {
        protected Zip(Map<String, Object> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$zip";
        }

        public static ZipBuilder arrayOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new ZipBuilder(Fields.field(fieldReference));
        }

        public static ZipBuilder arrayOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new ZipBuilder(expression);
        }

        public static ZipBuilder arrayOf(Collection<?> values) {
            Assert.notNull(values, (String)"Expression must not be null");
            return new ZipBuilder(values);
        }

        @Contract(value="-> new")
        public Zip useLongestLength() {
            return new Zip(this.append("useLongestLength", true));
        }

        @Contract(value="_ -> new")
        public Zip defaultTo(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Zip(this.append("defaults", Fields.field(fieldReference)));
        }

        @Contract(value="_ -> new")
        public Zip defaultTo(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Zip(this.append("defaults", expression));
        }

        @Contract(value="_ -> new")
        public Zip defaultTo(Object[] array) {
            Assert.notNull((Object)array, (String)"Array must not be null");
            return new Zip(this.append("defaults", Arrays.asList(array)));
        }

        public static class ZipBuilder {
            private final List<Object> sourceArrays = new ArrayList<Object>();

            private ZipBuilder(Object sourceArray) {
                this.sourceArrays.add(sourceArray);
            }

            public Zip zip(Object ... arrays) {
                Assert.notNull((Object)arrays, (String)"Arrays must not be null");
                for (Object value : arrays) {
                    if (value instanceof String) {
                        String stringValue = (String)value;
                        this.sourceArrays.add(Fields.field(stringValue));
                        continue;
                    }
                    this.sourceArrays.add(value);
                }
                return new Zip(Collections.singletonMap("inputs", this.sourceArrays));
            }
        }
    }

    public static class Reduce
    implements AggregationExpression {
        private final Object input;
        private final Object initialValue;
        private final List<AggregationExpression> reduceExpressions;

        private Reduce(Object input, Object initialValue, List<AggregationExpression> reduceExpressions) {
            this.input = input;
            this.initialValue = initialValue;
            this.reduceExpressions = reduceExpressions;
        }

        @Override
        public Document toDocument(AggregationOperationContext context) {
            Document document = new Document();
            document.put("input", this.getMappedValue(this.input, context));
            document.put("initialValue", this.getMappedValue(this.initialValue, context));
            if (this.reduceExpressions.iterator().next() instanceof PropertyExpression) {
                Document properties = new Document();
                for (AggregationExpression e : this.reduceExpressions) {
                    properties.putAll((Map)e.toDocument(context));
                }
                document.put("in", (Object)properties);
            } else {
                document.put("in", (Object)this.reduceExpressions.iterator().next().toDocument(context));
            }
            return new Document("$reduce", (Object)document);
        }

        private Object getMappedValue(Object value, AggregationOperationContext context) {
            if (value instanceof Document) {
                return value;
            }
            if (value instanceof AggregationExpression) {
                AggregationExpression aggregationExpression = (AggregationExpression)value;
                return aggregationExpression.toDocument(context);
            }
            if (value instanceof Field) {
                Field field = (Field)value;
                return context.getReference(field).toString();
            }
            return context.getMappedObject(new Document("###val###", value)).get((Object)"###val###");
        }

        public static InitialValueBuilder arrayOf(final String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new InitialValueBuilder(){

                @Override
                public ReduceBuilder withInitialValue(final Object initialValue) {
                    Assert.notNull((Object)initialValue, (String)"Initial value must not be null");
                    return new ReduceBuilder(){
                        final /* synthetic */ 1 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public Reduce reduce(AggregationExpression expression) {
                            Assert.notNull((Object)expression, (String)"AggregationExpression must not be null");
                            return new Reduce(Fields.field(fieldReference), initialValue, Collections.singletonList(expression));
                        }

                        @Override
                        public Reduce reduce(PropertyExpression ... expressions) {
                            Assert.notNull((Object)expressions, (String)"PropertyExpressions must not be null");
                            return new Reduce(Fields.field(fieldReference), initialValue, Arrays.asList(expressions));
                        }
                    };
                }
            };
        }

        public static InitialValueBuilder arrayOf(final AggregationExpression arrayValueExpression) {
            return new InitialValueBuilder(){

                @Override
                public ReduceBuilder withInitialValue(final Object initialValue) {
                    Assert.notNull((Object)initialValue, (String)"Initial value must not be null");
                    return new ReduceBuilder(){
                        final /* synthetic */ 2 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public Reduce reduce(AggregationExpression expression) {
                            Assert.notNull((Object)expression, (String)"AggregationExpression must not be null");
                            return new Reduce(arrayValueExpression, initialValue, Collections.singletonList(expression));
                        }

                        @Override
                        public Reduce reduce(PropertyExpression ... expressions) {
                            Assert.notNull((Object)expressions, (String)"PropertyExpressions must not be null");
                            return new Reduce(arrayValueExpression, initialValue, Arrays.asList(expressions));
                        }
                    };
                }
            };
        }

        public static class PropertyExpression
        implements AggregationExpression {
            private final String propertyName;
            private final AggregationExpression aggregationExpression;

            protected PropertyExpression(String propertyName, AggregationExpression aggregationExpression) {
                Assert.notNull((Object)propertyName, (String)"Property name must not be null");
                Assert.notNull((Object)aggregationExpression, (String)"AggregationExpression must not be null");
                this.propertyName = propertyName;
                this.aggregationExpression = aggregationExpression;
            }

            public static AsBuilder property(final String name) {
                return new AsBuilder(){

                    @Override
                    public PropertyExpression definedAs(AggregationExpression expression) {
                        return new PropertyExpression(name, expression);
                    }
                };
            }

            @Override
            public Document toDocument(AggregationOperationContext context) {
                return new Document(this.propertyName, (Object)this.aggregationExpression.toDocument(context));
            }

            public static interface AsBuilder {
                public PropertyExpression definedAs(AggregationExpression var1);
            }
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static enum Variable implements AggregationVariable
        {
            THIS{

                @Override
                public String getTarget() {
                    return "$$this";
                }

                public String toString() {
                    return this.getName();
                }
            }
            ,
            VALUE{

                @Override
                public String getTarget() {
                    return "$$value";
                }

                public String toString() {
                    return this.getName();
                }
            };


            @Override
            public boolean isInternal() {
                return true;
            }

            public Field referringTo(final String property) {
                return new Field(){
                    final /* synthetic */ Variable this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public String getName() {
                        return this.this$0.getName() + "." + property;
                    }

                    @Override
                    public String getTarget() {
                        return this.this$0.getTarget() + "." + property;
                    }

                    @Override
                    public boolean isAliased() {
                        return false;
                    }

                    public String toString() {
                        return this.getName();
                    }
                };
            }

            public static boolean isVariable(Field field) {
                for (Variable var : Variable.values()) {
                    if (!field.getTarget().startsWith(var.getTarget())) continue;
                    return true;
                }
                return false;
            }
        }

        public static interface ReduceBuilder {
            public Reduce reduce(AggregationExpression var1);

            public Reduce reduce(PropertyExpression ... var1);
        }

        public static interface InitialValueBuilder {
            public ReduceBuilder withInitialValue(Object var1);
        }
    }

    public static class ReverseArray
    extends AbstractAggregationExpression {
        private ReverseArray(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$reverseArray";
        }

        public static ReverseArray reverseArrayOf(String fieldReference) {
            return new ReverseArray(Fields.field(fieldReference));
        }

        public static ReverseArray reverseArrayOf(AggregationExpression expression) {
            return new ReverseArray(expression);
        }

        public static ReverseArray reverseArrayOf(Collection<?> values) {
            return new ReverseArray(values);
        }
    }

    public static class RangeOperator
    extends AbstractAggregationExpression {
        private RangeOperator(List<Object> values) {
            super(values);
        }

        @Override
        protected String getMongoMethod() {
            return "$range";
        }

        public static RangeOperatorBuilder rangeStartingAt(String fieldReference) {
            return new RangeOperatorBuilder(Fields.field(fieldReference));
        }

        public static RangeOperatorBuilder rangeStartingAt(AggregationExpression expression) {
            return new RangeOperatorBuilder(expression);
        }

        public static RangeOperatorBuilder rangeStartingAt(long value) {
            return new RangeOperatorBuilder(value);
        }

        @Contract(value="_ -> new")
        public RangeOperator withStepSize(long stepSize) {
            return new RangeOperator(this.append(stepSize));
        }

        public static class RangeOperatorBuilder {
            private final Object startPoint;

            private RangeOperatorBuilder(Object startPoint) {
                this.startPoint = startPoint;
            }

            public RangeOperator to(long index) {
                return new RangeOperator(Arrays.asList(this.startPoint, index));
            }

            public RangeOperator to(AggregationExpression expression) {
                return new RangeOperator(Arrays.asList(this.startPoint, expression));
            }

            public RangeOperator to(String fieldReference) {
                return new RangeOperator(Arrays.asList(this.startPoint, Fields.field(fieldReference)));
            }
        }
    }

    public static class IndexOfArray
    extends AbstractAggregationExpression {
        private IndexOfArray(List<Object> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$indexOfArray";
        }

        public static IndexOfArrayBuilder arrayOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new IndexOfArrayBuilder(Fields.field(fieldReference));
        }

        public static IndexOfArrayBuilder arrayOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new IndexOfArrayBuilder(expression);
        }

        public static IndexOfArrayBuilder arrayOf(Collection<?> values) {
            Assert.notNull(values, (String)"Values must not be null");
            return new IndexOfArrayBuilder(values);
        }

        @Contract(value="_ -> new")
        public IndexOfArray within(Range<Long> range) {
            return new IndexOfArray(this.append(AggregationUtils.toRangeValues(range)));
        }

        public static class IndexOfArrayBuilder {
            private final Object targetArray;

            private IndexOfArrayBuilder(Object targetArray) {
                this.targetArray = targetArray;
            }

            public IndexOfArray indexOf(Object value) {
                Assert.notNull((Object)value, (String)"Value must not be null");
                return new IndexOfArray(Arrays.asList(this.targetArray, value));
            }
        }
    }

    public static class Slice
    extends AbstractAggregationExpression {
        private Slice(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$slice";
        }

        public static Slice sliceArrayOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Slice(Slice.asFields(fieldReference));
        }

        public static Slice sliceArrayOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Slice(Collections.singletonList(expression));
        }

        public static Slice sliceArrayOf(Collection<?> values) {
            Assert.notNull(values, (String)"Values must not be null");
            return new Slice(Collections.singletonList(values));
        }

        @Contract(value="_ -> new")
        public Slice itemCount(int count) {
            return new Slice(this.append(count));
        }

        @Contract(value="_ -> new")
        public Slice itemCount(AggregationExpression count) {
            return new Slice(this.append(count));
        }

        public SliceElementsBuilder offset(int position) {
            return new SliceElementsBuilder(position);
        }

        public SliceElementsBuilder offset(AggregationExpression position) {
            return new SliceElementsBuilder(position);
        }

        public class SliceElementsBuilder {
            private final Object position;

            SliceElementsBuilder(Object position) {
                this.position = position;
            }

            public Slice itemCount(int count) {
                return new Slice(Slice.this.append(this.position)).itemCount(count);
            }

            public Slice itemCount(AggregationExpression count) {
                return new Slice(Slice.this.append(this.position)).itemCount(count);
            }
        }
    }

    public static class Size
    extends AbstractAggregationExpression {
        private Size(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$size";
        }

        public static Size lengthOfArray(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Size(Fields.field(fieldReference));
        }

        public static Size lengthOfArray(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Size(expression);
        }

        public static Size lengthOfArray(Collection<?> values) {
            Assert.notNull(values, (String)"Values must not be null");
            return new Size(Collections.singletonList(values));
        }
    }

    public static class IsArray
    extends AbstractAggregationExpression {
        private IsArray(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$isArray";
        }

        public static IsArray isArray(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new IsArray(Fields.field(fieldReference));
        }

        public static IsArray isArray(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new IsArray(expression);
        }
    }

    public static class Filter
    implements AggregationExpression {
        private @Nullable Object input;
        private @Nullable ExposedFields.ExposedField as;
        private @Nullable Object condition;

        private Filter() {
        }

        public static AsBuilder filter(String field) {
            Assert.notNull((Object)field, (String)"Field must not be null");
            return Filter.filter(Fields.field(field));
        }

        public static AsBuilder filter(Field field) {
            Assert.notNull((Object)field, (String)"Field must not be null");
            return new FilterExpressionBuilder().filter(field);
        }

        public static AsBuilder filter(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Field must not be null");
            return new FilterExpressionBuilder().filter(expression);
        }

        public static AsBuilder filter(List<?> values) {
            Assert.notNull(values, (String)"Values must not be null");
            return new FilterExpressionBuilder().filter(values);
        }

        @Override
        public Document toDocument(AggregationOperationContext context) {
            Assert.notNull((Object)this.as, (String)"As must be set first");
            return this.toFilter(ExposedFields.from(this.as), context);
        }

        private Document toFilter(ExposedFields exposedFields, AggregationOperationContext context) {
            Document filterExpression = new Document();
            AggregationOperationContext operationContext = context.inheritAndExpose(exposedFields);
            filterExpression.putAll((Map)context.getMappedObject(new Document("input", this.getMappedInput(context))));
            filterExpression.put("as", (Object)this.as.getTarget());
            filterExpression.putAll((Map)context.getMappedObject(new Document("cond", this.getMappedCondition(operationContext))));
            return new Document("$filter", (Object)filterExpression);
        }

        private @Nullable Object getMappedInput(AggregationOperationContext context) {
            Object object = this.input;
            if (object instanceof Field) {
                Field field = (Field)object;
                return context.getReference(field).toString();
            }
            object = this.input;
            if (object instanceof AggregationExpression) {
                AggregationExpression expression = (AggregationExpression)object;
                return expression.toDocument(context);
            }
            return this.input;
        }

        private @Nullable Object getMappedCondition(AggregationOperationContext context) {
            Object object = this.condition;
            if (!(object instanceof AggregationExpression)) {
                return this.condition;
            }
            AggregationExpression aggregationExpression = (AggregationExpression)object;
            NestedDelegatingExpressionAggregationOperationContext nea = new NestedDelegatingExpressionAggregationOperationContext(context, Collections.singleton(this.as));
            return aggregationExpression.toDocument(nea);
        }

        public static interface AsBuilder {
            public ConditionBuilder as(String var1);
        }

        static final class FilterExpressionBuilder
        implements InputBuilder,
        AsBuilder,
        ConditionBuilder {
            private final Filter filter = new Filter();

            FilterExpressionBuilder() {
            }

            public static InputBuilder newBuilder() {
                return new FilterExpressionBuilder();
            }

            @Override
            @Contract(value="_ -> this")
            public AsBuilder filter(List<?> array) {
                Assert.notNull(array, (String)"Array must not be null");
                this.filter.input = new ArrayList(array);
                return this;
            }

            @Override
            @Contract(value="_ -> this")
            public AsBuilder filter(Field field) {
                Assert.notNull((Object)field, (String)"Field must not be null");
                this.filter.input = field;
                return this;
            }

            @Override
            @Contract(value="_ -> this")
            public AsBuilder filter(AggregationExpression expression) {
                Assert.notNull((Object)expression, (String)"Expression must not be null");
                this.filter.input = expression;
                return this;
            }

            @Override
            @Contract(value="_ -> this")
            public ConditionBuilder as(String variableName) {
                Assert.notNull((Object)variableName, (String)"Variable name  must not be null");
                this.filter.as = new ExposedFields.ExposedField(variableName, true);
                return this;
            }

            @Override
            public Filter by(AggregationExpression condition) {
                Assert.notNull((Object)condition, (String)"Condition must not be null");
                this.filter.condition = condition;
                return this.filter;
            }

            @Override
            public Filter by(String expression) {
                Assert.notNull((Object)expression, (String)"Expression must not be null");
                this.filter.condition = expression;
                return this.filter;
            }

            @Override
            public Filter by(Document expression) {
                Assert.notNull((Object)expression, (String)"Expression must not be null");
                this.filter.condition = expression;
                return this.filter;
            }
        }

        public static interface ConditionBuilder {
            public Filter by(AggregationExpression var1);

            public Filter by(String var1);

            public Filter by(Document var1);
        }

        public static interface InputBuilder {
            public AsBuilder filter(List<?> var1);

            public AsBuilder filter(Field var1);

            public AsBuilder filter(AggregationExpression var1);
        }
    }

    public static class ConcatArrays
    extends AbstractAggregationExpression {
        private ConcatArrays(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$concatArrays";
        }

        public static ConcatArrays arrayOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new ConcatArrays(ConcatArrays.asFields(fieldReference));
        }

        public static ConcatArrays arrayOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new ConcatArrays(Collections.singletonList(expression));
        }

        public static ConcatArrays arrayOf(Collection<?> values) {
            Assert.notNull(values, (String)"Values must not be null");
            return new ConcatArrays(Collections.singletonList(values));
        }

        @Contract(value="_ -> new")
        public ConcatArrays concat(String arrayFieldReference) {
            Assert.notNull((Object)arrayFieldReference, (String)"ArrayFieldReference must not be null");
            return new ConcatArrays(this.append(Fields.field(arrayFieldReference)));
        }

        @Contract(value="_ -> new")
        public ConcatArrays concat(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new ConcatArrays(this.append(expression));
        }
    }

    public static class ArrayElemAt
    extends AbstractAggregationExpression {
        private ArrayElemAt(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$arrayElemAt";
        }

        public static ArrayElemAt arrayOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new ArrayElemAt(ArrayElemAt.asFields(fieldReference));
        }

        public static ArrayElemAt arrayOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new ArrayElemAt(Collections.singletonList(expression));
        }

        public static ArrayElemAt arrayOf(Collection<?> values) {
            Assert.notNull(values, (String)"Values must not be null");
            return new ArrayElemAt(Collections.singletonList(values));
        }

        @Contract(value="_ -> new")
        public ArrayElemAt elementAt(int index) {
            return new ArrayElemAt(this.append(index));
        }

        @Contract(value="_ -> new")
        public ArrayElemAt elementAt(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new ArrayElemAt(this.append(expression));
        }

        @Contract(value="_ -> new")
        public ArrayElemAt elementAt(String arrayFieldReference) {
            Assert.notNull((Object)arrayFieldReference, (String)"ArrayReference must not be null");
            return new ArrayElemAt(this.append(Fields.field(arrayFieldReference)));
        }
    }
}

