/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Polygon;
import org.springframework.data.geo.Shape;
import org.springframework.data.mongodb.core.geo.GeoJson;
import org.springframework.data.mongodb.core.geo.Sphere;

class AotPlaceholders {
    AotPlaceholders() {
    }

    static Placeholder indexed(int position) {
        return new PlaceholderImpl("?" + position);
    }

    static Placeholder geoJson(int index, String type) {
        return new GeoJsonPlaceholder(index, type);
    }

    static Placeholder point(int index) {
        return new PointPlaceholder(index);
    }

    static Placeholder circle(int index) {
        return new CirclePlaceholder(index);
    }

    static Placeholder box(int index) {
        return new BoxPlaceholder(index);
    }

    static Placeholder sphere(int index) {
        return new SpherePlaceholder(index);
    }

    static Placeholder polygon(int index) {
        return new PolygonPlaceholder(index);
    }

    static RegexPlaceholder regex(int index, @Nullable String options) {
        return new RegexPlaceholder(index, options);
    }

    static Placeholder asList(int index) {
        return AotPlaceholders.asList(AotPlaceholders.indexed(index));
    }

    static Placeholder asList(Placeholder source) {
        return new AsListPlaceholder(source);
    }

    record PlaceholderImpl(String expression) implements Placeholder
    {
        @Override
        public String getValue() {
            return this.expression;
        }

        @Override
        public String toString() {
            return this.getValue();
        }
    }

    private record GeoJsonPlaceholder(int index, String type) implements Placeholder,
    GeoJson<List<Placeholder>>,
    Shape
    {
        @Override
        public String getValue() {
            return "?" + this.index;
        }

        @Override
        public String getType() {
            return this.type();
        }

        @Override
        public String toString() {
            return this.getValue();
        }

        @Override
        public List<Placeholder> getCoordinates() {
            return List.of();
        }
    }

    private static class PointPlaceholder
    extends Point
    implements Placeholder {
        private final int index;

        PointPlaceholder(int index) {
            super(Double.NaN, Double.NaN);
            this.index = index;
        }

        @Override
        public String getValue() {
            return "?" + this.index;
        }

        public String toString() {
            return this.getValue();
        }
    }

    private static class CirclePlaceholder
    extends Circle
    implements Placeholder {
        private final int index;

        CirclePlaceholder(int index) {
            super((Point)new PointPlaceholder(index), Distance.of((double)1.0, (Metric)Metrics.NEUTRAL));
            this.index = index;
        }

        @Override
        public String getValue() {
            return "?" + this.index;
        }

        public String toString() {
            return this.getValue();
        }
    }

    private static class BoxPlaceholder
    extends Box
    implements Placeholder {
        private final int index;

        BoxPlaceholder(int index) {
            super((Point)new PointPlaceholder(index), (Point)new PointPlaceholder(index));
            this.index = index;
        }

        @Override
        public String getValue() {
            return "?" + this.index;
        }

        public String toString() {
            return this.getValue();
        }
    }

    private static class SpherePlaceholder
    extends Sphere
    implements Placeholder {
        private final int index;

        SpherePlaceholder(int index) {
            super((Point)new PointPlaceholder(index), Distance.of((double)1.0, (Metric)Metrics.NEUTRAL));
            this.index = index;
        }

        @Override
        public String getValue() {
            return "?" + this.index;
        }

        @Override
        public String toString() {
            return this.getValue();
        }
    }

    private static class PolygonPlaceholder
    extends Polygon
    implements Placeholder {
        private final int index;

        PolygonPlaceholder(int index) {
            super((Point)new PointPlaceholder(index), (Point)new PointPlaceholder(index), (Point)new PointPlaceholder(index), new Point[]{new PointPlaceholder(index)});
            this.index = index;
        }

        @Override
        public String getValue() {
            return "?" + this.index;
        }

        public String toString() {
            return this.getValue();
        }
    }

    static class RegexPlaceholder
    implements Placeholder {
        private final int index;
        private final @Nullable String options;

        RegexPlaceholder(int index, @Nullable String options) {
            this.index = index;
            this.options = options;
        }

        @Nullable String regexOptions() {
            return this.options;
        }

        @Override
        public String getValue() {
            return "?" + this.index;
        }

        public String toString() {
            return this.getValue();
        }
    }

    static interface Placeholder {
        public String getValue();

        default public <T extends Placeholder> @Nullable T unwrap(Class<? extends T> targetType) {
            return (T)(targetType.isInstance(this) ? (Placeholder)targetType.cast(this) : null);
        }
    }

    record AsListPlaceholder(Placeholder placeholder) implements Placeholder
    {
        @Override
        public <T extends Placeholder> @Nullable T unwrap(Class<? extends T> targetType) {
            if (targetType.isInstance(this.placeholder)) {
                return (T)((Placeholder)targetType.cast(this.placeholder));
            }
            return Placeholder.super.unwrap(targetType);
        }

        @Override
        public String toString() {
            return this.getValue();
        }

        @Override
        public String getValue() {
            return "[" + this.placeholder.getValue() + "]";
        }
    }
}

