/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.util.spel;

import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.data.expression.ValueEvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.StringUtils;

public final class ExpressionUtils {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();

    public static @Nullable Expression detectExpression(@Nullable String potentialExpression) {
        if (!StringUtils.hasText((String)potentialExpression)) {
            return null;
        }
        Expression expression = PARSER.parseExpression(potentialExpression, ParserContext.TEMPLATE_EXPRESSION);
        return expression instanceof LiteralExpression ? null : expression;
    }

    public static @Nullable Object evaluate(String value, Supplier<ValueEvaluationContext> evaluationContext) {
        Expression expression = ExpressionUtils.detectExpression(value);
        if (expression == null) {
            return value;
        }
        return expression.getValue((Object)evaluationContext.get(), Object.class);
    }
}

