/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.query;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.converter.RestTableResultExtractor;
import org.neo4j.rest.graphdb.query.CypherResult;
import org.neo4j.rest.graphdb.util.ConvertedResult;
import org.neo4j.rest.graphdb.util.Handler;
import org.neo4j.rest.graphdb.util.QueryResult;
import org.neo4j.rest.graphdb.util.QueryResultBuilder;
import org.neo4j.rest.graphdb.util.ResultConverter;

public class RestQueryResult
implements QueryResult<Map<String, Object>> {
    private QueryResultBuilder<Map<String, Object>> result;
    private ResultConverter resultConverter;

    @Override
    public <R> ConvertedResult<R> to(Class<R> type) {
        this.checkResult();
        return this.result.to(type);
    }

    @Override
    public <R> ConvertedResult<R> to(Class<R> type, ResultConverter<Map<String, Object>, R> converter) {
        this.checkResult();
        return this.result.to(type, converter);
    }

    @Override
    public void handle(Handler<Map<String, Object>> handler) {
        this.checkResult();
        this.result.handle(handler);
    }

    @Override
    public Iterator<Map<String, Object>> iterator() {
        this.checkResult();
        return this.result.iterator();
    }

    private void checkResult() {
        if (this.result == null) {
            throw new IllegalStateException("Result not yet available, please finish the transaction first.");
        }
    }

    public static QueryResultBuilder<Map<String, Object>> toQueryResult(CypherResult responseData, RestAPI restApi, ResultConverter resultConverter) {
        RestTableResultExtractor extractor = new RestTableResultExtractor(restApi.getEntityExtractor());
        List<Map<String, Object>> data = extractor.extract(responseData.asMap());
        return new QueryResultBuilder<Map<String, Object>>(data, resultConverter);
    }
}

