/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.graphdb.traversal.BidirectionalTraversalDescription;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.rest.graphdb.AbstractRemoteDatabase;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.RestAPICypherImpl;
import org.neo4j.rest.graphdb.RestAPIImpl;
import org.neo4j.rest.graphdb.RestAPIProvider;
import org.neo4j.rest.graphdb.entity.RestNode;
import org.neo4j.rest.graphdb.index.RestIndexManager;
import org.neo4j.rest.graphdb.query.RestCypherTransactionManager;
import org.neo4j.rest.graphdb.traversal.RestTraversalDescription;
import org.neo4j.rest.graphdb.util.ResourceIterableWrapper;

public class CypherRestGraphDatabase
extends AbstractRemoteDatabase
implements RestAPIProvider {
    private RestAPICypherImpl restAPI;

    public CypherRestGraphDatabase(RestAPI restAPI) {
        this.restAPI = new RestAPICypherImpl(restAPI);
    }

    public CypherRestGraphDatabase(String uri) {
        this(new RestAPIImpl(uri));
    }

    public CypherRestGraphDatabase(String uri, String user, String password) {
        this(new RestAPIImpl(uri, user, password));
    }

    @Override
    public RestAPI getRestAPI() {
        return this.restAPI;
    }

    public RestIndexManager index() {
        return this.restAPI.index();
    }

    public Node createNode() {
        return this.restAPI.createNode(null);
    }

    public Node getNodeById(long id) {
        return this.restAPI.getNodeById(id);
    }

    public Iterable<Node> getAllNodes() {
        return this.restAPI.getAllNodes();
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.restAPI.getRelationshipTypes();
    }

    public Relationship getRelationshipById(long id) {
        return this.restAPI.getRelationshipById(id);
    }

    public String getStoreDir() {
        return this.restAPI.getBaseUri();
    }

    public boolean isAvailable(long timeout) {
        return this.restAPI != null;
    }

    public RestCypherTransactionManager getTxManager() {
        return this.restAPI.getTxManager();
    }

    public DependencyResolver getDependencyResolver() {
        return new DependencyResolver.Adapter(){

            public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) throws IllegalArgumentException {
                if (TransactionManager.class.isAssignableFrom(type)) {
                    return (T)CypherRestGraphDatabase.this.getTxManager();
                }
                return null;
            }
        };
    }

    @Override
    public Transaction beginTx() {
        return this.restAPI.beginTx();
    }

    @Override
    public void shutdown() {
        try {
            this.getTxManager().rollback();
        }
        catch (IllegalStateException | SystemException throwable) {
            // empty catch block
        }
        this.restAPI.close();
    }

    public Node createNode(Label ... labels) {
        return this.restAPI.createNode(null, this.toLabelNames(labels));
    }

    public Set<String> toLabelNames(Label[] labels) {
        LinkedHashSet<String> labelNames = new LinkedHashSet<String>(labels.length);
        for (Label label : labels) {
            labelNames.add(label.name());
        }
        return labelNames;
    }

    public ResourceIterable<Node> findNodesByLabelAndProperty(Label label, String property, Object value) {
        Iterable<RestNode> nodes = this.restAPI.getNodesByLabelAndProperty(label.name(), property, value);
        return new ResourceIterableWrapper<Node, RestNode>(nodes){

            protected Node underlyingObjectToObject(RestNode node) {
                return node;
            }
        };
    }

    public ResourceIterator<Node> findNodes(Label label, String property, Object value) {
        return this.findNodesByLabelAndProperty(label, property, value).iterator();
    }

    public Node findNode(Label label, String property, Object value) {
        return (Node)IteratorUtil.single(this.findNodes(label, property, value));
    }

    public ResourceIterator<Node> findNodes(Label label) {
        Iterable<RestNode> nodes = this.restAPI.getNodesByLabel(label.name());
        return new ResourceIterableWrapper<Node, RestNode>(nodes){

            protected Node underlyingObjectToObject(RestNode node) {
                return node;
            }
        }.iterator();
    }

    @Override
    public Result execute(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Result execute(String s, Map<String, Object> map) {
        throw new UnsupportedOperationException();
    }

    public Schema schema() {
        throw new UnsupportedOperationException();
    }

    public RestTraversalDescription traversalDescription() {
        return this.restAPI.createTraversalDescription();
    }

    public BidirectionalTraversalDescription bidirectionalTraversalDescription() {
        throw new UnsupportedOperationException();
    }

    public Collection<String> getAllLabelNames() {
        return this.restAPI.getAllLabelNames();
    }
}

