/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.converter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.rest.graphdb.RequestResult;
import org.neo4j.rest.graphdb.converter.RestEntityExtractor;
import org.neo4j.rest.graphdb.converter.RestResultConverter;

public class RestTableResultExtractor
implements RestResultConverter {
    private final RestEntityExtractor restEntityExtractor;

    public RestTableResultExtractor(RestEntityExtractor restEntityExtractor) {
        this.restEntityExtractor = restEntityExtractor;
    }

    public List<Map<String, Object>> extract(Map<?, ?> restResult) {
        List columns = (List)restResult.get("columns");
        return this.extractData(restResult, columns);
    }

    private List<Map<String, Object>> extractData(Map<?, ?> restResult, List<String> columns) {
        List rows = (List)restResult.get("data");
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(rows.size());
        for (List row : rows) {
            result.add(this.mapRow(columns, row));
        }
        return result;
    }

    private Map<String, Object> mapRow(List<String> columns, List<?> row) {
        int columnCount = columns.size();
        HashMap<String, Object> newRow = new HashMap<String, Object>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            Object value = row.get(i);
            newRow.put(columns.get(i), this.restEntityExtractor.convertFromRepresentation(value));
        }
        return newRow;
    }

    @Override
    public Object convertFromRepresentation(RequestResult value) {
        return this.extract(this.toMap(value));
    }

    public boolean canHandle(Object restResult) {
        return restResult instanceof Map && ((Map)restResult).containsKey("columns") && ((Map)restResult).containsKey("data");
    }

    public Map<?, ?> toMap(RequestResult requestResult) {
        return requestResult.toMap();
    }
}

