/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.util;

import java.util.Iterator;
import org.neo4j.graphdb.ResourceIterator;

public class WrappingResourceIterator<T>
implements ResourceIterator<T> {
    private final Iterator<T> iterator;
    boolean hasNext;

    public WrappingResourceIterator(Iterator<T> iterator) {
        this.iterator = iterator;
        this.hasNext = iterator.hasNext();
    }

    public void close() {
        this.hasNext = false;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public T next() {
        this.assertHasNext();
        T result = this.iterator.next();
        this.hasNext = this.iterator.hasNext();
        return result;
    }

    public void remove() {
        this.assertHasNext();
        try {
            this.iterator.remove();
        }
        finally {
            this.hasNext = this.iterator.hasNext();
        }
    }

    private void assertHasNext() {
        if (!this.hasNext) {
            throw new IllegalArgumentException("Iterator already closed");
        }
    }
}

