/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.index;

import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.ReadableIndex;
import org.neo4j.graphdb.index.ReadableRelationshipIndex;
import org.neo4j.graphdb.index.RelationshipAutoIndexer;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.index.impl.lucene.LuceneIndexImplementation;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.index.IndexInfo;
import org.neo4j.rest.graphdb.index.RestAutoIndexer;
import org.neo4j.rest.graphdb.index.RestIndex;
import org.neo4j.rest.graphdb.index.RestNodeIndex;
import org.neo4j.rest.graphdb.index.RestRelationshipAutoIndexer;
import org.neo4j.rest.graphdb.index.RestRelationshipIndex;

public class RestIndexManager
implements IndexManager {
    public static final String RELATIONSHIP = "relationship";
    public static final String NODE = "node";
    public static final String NODE_AUTO_INDEX_NAME = "node_auto_index";
    public static final String RELATIONSHIP_AUTO_INDEX_NAME = "relationship_auto_index";
    private final RestAPI restApi;
    private ReadableIndex<Node> nodeAutoIndex;
    private ReadableRelationshipIndex relationshipAutoIndex;

    public RestIndexManager(RestAPI restApi) {
        this.restApi = restApi;
    }

    public boolean existsForNodes(String indexName) {
        return this.indexInfo(NODE).exists(indexName);
    }

    private IndexInfo indexInfo(String indexType) {
        return this.restApi.indexInfo(indexType);
    }

    private boolean checkIndex(String indexType, String indexName, Map<String, String> config) {
        IndexInfo indexInfo = this.indexInfo(indexType);
        return indexInfo.checkConfig(indexName, config);
    }

    public boolean noConfigProvided(Map<String, String> config) {
        return config == null || config.isEmpty();
    }

    public RestIndex<Node> forNodes(String indexName) {
        if (!this.checkIndex(NODE, indexName, null)) {
            this.createIndex(NODE, indexName, LuceneIndexImplementation.EXACT_CONFIG);
        }
        return new RestNodeIndex(indexName, this.restApi);
    }

    public RestIndex<Node> forNodes(String indexName, Map<String, String> config) {
        if (this.noConfigProvided(config)) {
            throw new IllegalArgumentException("No index configuration was provided!");
        }
        if (!this.checkIndex(NODE, indexName, config)) {
            this.createIndex(NODE, indexName, config);
        }
        return new RestNodeIndex(indexName, this.restApi);
    }

    public String[] nodeIndexNames() {
        IndexInfo indexInfo = this.indexInfo(NODE);
        return indexInfo.indexNames();
    }

    public boolean existsForRelationships(String indexName) {
        return this.indexInfo(RELATIONSHIP).exists(indexName);
    }

    public RelationshipIndex forRelationships(String indexName) {
        if (!this.checkIndex(RELATIONSHIP, indexName, null)) {
            this.createIndex(RELATIONSHIP, indexName, LuceneIndexImplementation.EXACT_CONFIG);
        }
        return new RestRelationshipIndex(indexName, this.restApi);
    }

    public RelationshipIndex forRelationships(String indexName, Map<String, String> config) {
        if (this.noConfigProvided(config)) {
            throw new IllegalArgumentException("No index configuration was provided!");
        }
        if (!this.checkIndex(RELATIONSHIP, indexName, config)) {
            this.createIndex(RELATIONSHIP, indexName, config);
        }
        return new RestRelationshipIndex(indexName, this.restApi);
    }

    private void createIndex(String type, String indexName, Map<String, String> config) {
        this.restApi.createIndex(type, indexName, config);
    }

    public String[] relationshipIndexNames() {
        return this.indexInfo(RELATIONSHIP).indexNames();
    }

    public Map<String, String> getConfiguration(Index<? extends PropertyContainer> index) {
        String typeName = this.typeName(index.getEntityType());
        return this.indexInfo(typeName).getConfig(index.getName());
    }

    private String typeName(Class<? extends PropertyContainer> type) {
        if (Node.class.isAssignableFrom(type)) {
            return NODE;
        }
        if (Relationship.class.isAssignableFrom(type)) {
            return RELATIONSHIP;
        }
        throw new IllegalArgumentException("Invalid index type " + type);
    }

    public String setConfiguration(Index<? extends PropertyContainer> index, String s, String s1) {
        throw new UnsupportedOperationException();
    }

    public String removeConfiguration(Index<? extends PropertyContainer> index, String s) {
        throw new UnsupportedOperationException();
    }

    public AutoIndexer<Node> getNodeAutoIndexer() {
        return new RestAutoIndexer<Node>(this.restApi, Node.class, this.getNodeAutoIndex());
    }

    public RelationshipAutoIndexer getRelationshipAutoIndexer() {
        return new RestRelationshipAutoIndexer(this.restApi, this.getRelationshipAutoIndex());
    }

    private ReadableIndex<Node> getNodeAutoIndex() {
        if (this.nodeAutoIndex == null) {
            this.nodeAutoIndex = this.forNodes(NODE_AUTO_INDEX_NAME);
        }
        return this.nodeAutoIndex;
    }

    private ReadableRelationshipIndex getRelationshipAutoIndex() {
        if (this.relationshipAutoIndex == null) {
            this.relationshipAutoIndex = this.forRelationships(RELATIONSHIP_AUTO_INDEX_NAME);
        }
        return this.relationshipAutoIndex;
    }
}

