/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.util;

import java.util.concurrent.TimeUnit;

public class Config {
    public static final String CONFIG_PREFIX = "org.neo4j.rest.";
    public static final String CONFIG_STREAM = "org.neo4j.rest.stream";
    public static final String CONFIG_BATCH_TRANSACTION = "org.neo4j.rest.batch_transaction";
    public static final String CONFIG_LOG_REQUESTS = "org.neo4j.rest.logging_filter";
    public static final String WRITE_THREADS = "write_threads";
    public static final String IGNORE_SSL_HANDSHAKE = "org.neo4j.rest.ignore_ssl_handshake";

    public static int getConnectTimeout() {
        return Config.getTimeout("connect_timeout", 30);
    }

    public static int getReadTimeout() {
        return Config.getTimeout("read_timeout", 30);
    }

    public static boolean streamingIsEnabled() {
        return Boolean.parseBoolean(System.getProperty(CONFIG_STREAM, "true"));
    }

    public static boolean useBatchTransactions() {
        return System.getProperty(CONFIG_BATCH_TRANSACTION, "false").equalsIgnoreCase("true");
    }

    public static boolean useLoggingFilter() {
        return System.getProperty(CONFIG_LOG_REQUESTS, "false").equalsIgnoreCase("true");
    }

    private static int getTimeout(String param, int defaultValue) {
        return (int)TimeUnit.SECONDS.toMillis(Integer.parseInt(System.getProperty(CONFIG_PREFIX + param, "" + defaultValue)));
    }

    public static int getWriterThreads() {
        return Integer.parseInt(System.getProperty("org.neo4j.rest.write_threads", "10"));
    }

    public static boolean ignoreSSLHandshake() {
        return System.getProperty(IGNORE_SSL_HANDSHAKE, "false").equalsIgnoreCase("true");
    }
}

