/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.KotlinDetector;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.EntityInstantiator;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.neo4j.core.convert.ConvertWith;
import org.springframework.data.neo4j.core.convert.Neo4jConversionService;
import org.springframework.data.neo4j.core.convert.Neo4jConversions;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyConverter;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyConverterFactory;
import org.springframework.data.neo4j.core.mapping.CreateRelationshipStatementHolder;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.data.neo4j.core.mapping.DefaultNeo4jConversionService;
import org.springframework.data.neo4j.core.mapping.DefaultNeo4jEntityConverter;
import org.springframework.data.neo4j.core.mapping.DefaultNeo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.DefaultNeo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.DefaultRelationshipDescription;
import org.springframework.data.neo4j.core.mapping.MappingSupport;
import org.springframework.data.neo4j.core.mapping.Neo4jEntityConverter;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.NodeDescriptionStore;
import org.springframework.data.neo4j.core.mapping.NullSafeNeo4jPersistentPropertyConverter;
import org.springframework.data.neo4j.core.mapping.PersistentPropertyCharacteristics;
import org.springframework.data.neo4j.core.mapping.PersistentPropertyCharacteristicsProvider;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.data.neo4j.core.mapping.Schema;
import org.springframework.data.neo4j.core.mapping.callback.EventSupport;
import org.springframework.data.neo4j.core.schema.IdGenerator;
import org.springframework.data.neo4j.core.schema.Node;
import org.springframework.data.neo4j.core.schema.PostLoad;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;

@API(status=API.Status.STABLE, since="6.0")
public final class Neo4jMappingContext
extends AbstractMappingContext<Neo4jPersistentEntity<?>, Neo4jPersistentProperty>
implements Schema {
    private static final EntityInstantiators INSTANTIATORS = new EntityInstantiators();
    private static final Set<Class<?>> VOID_TYPES = new HashSet<Class>(Arrays.asList(Void.class, Void.TYPE));
    private final Map<Class<? extends IdGenerator<?>>, IdGenerator<?>> idGenerators = new ConcurrentHashMap();
    private final Map<Class<? extends Neo4jPersistentPropertyConverterFactory>, Neo4jPersistentPropertyConverterFactory> converterFactories = new ConcurrentHashMap<Class<? extends Neo4jPersistentPropertyConverterFactory>, Neo4jPersistentPropertyConverterFactory>();
    private final NodeDescriptionStore nodeDescriptionStore = new NodeDescriptionStore();
    private final TypeSystem typeSystem;
    private final Neo4jConversionService conversionService;
    private final Map<Neo4jPersistentEntity, Set<MethodHolder>> postLoadMethods = new ConcurrentHashMap<Neo4jPersistentEntity, Set<MethodHolder>>();
    private EventSupport eventSupport;
    @Nullable
    private AutowireCapableBeanFactory beanFactory;
    private boolean strict = false;
    private final Lazy<PersistentPropertyCharacteristicsProvider> propertyCharacteristicsProvider;

    public static Builder builder() {
        return new Builder();
    }

    public Neo4jMappingContext() {
        this(new Builder());
    }

    public Neo4jMappingContext(Neo4jConversions neo4jConversions) {
        this(new Builder(neo4jConversions, null, null));
    }

    @API(status=API.Status.INTERNAL, since="6.0")
    @Deprecated
    public Neo4jMappingContext(Neo4jConversions neo4jConversions, @Nullable TypeSystem typeSystem) {
        this(new Builder(neo4jConversions, typeSystem, null));
    }

    private Neo4jMappingContext(Builder builder) {
        this.conversionService = new DefaultNeo4jConversionService(builder.neo4jConversions);
        this.typeSystem = builder.typeSystem == null ? InternalTypeSystem.TYPE_SYSTEM : builder.typeSystem;
        this.eventSupport = EventSupport.useExistingCallbacks(this, EntityCallbacks.create());
        super.setSimpleTypeHolder(builder.neo4jConversions.getSimpleTypeHolder());
        PersistentPropertyCharacteristicsProvider characteristicsProvider = builder.persistentPropertyCharacteristicsProvider;
        this.propertyCharacteristicsProvider = Lazy.of(() -> characteristicsProvider != null || this.beanFactory == null ? characteristicsProvider : (PersistentPropertyCharacteristicsProvider)this.beanFactory.getBeanProvider(PersistentPropertyCharacteristicsProvider.class).getIfUnique());
    }

    public void setStrict(boolean strict) {
        super.setStrict(strict);
        this.strict = strict;
    }

    @Override
    public Neo4jEntityConverter getEntityConverter() {
        return new DefaultNeo4jEntityConverter(INSTANTIATORS, this.nodeDescriptionStore, this.conversionService, this.eventSupport, this.typeSystem);
    }

    public Neo4jConversionService getConversionService() {
        return this.conversionService;
    }

    public EntityInstantiator getInstantiatorFor(PersistentEntity<?, ?> entity) {
        return INSTANTIATORS.getInstantiatorFor(entity);
    }

    public boolean hasCustomWriteTarget(Class<?> targetType) {
        return this.conversionService.hasCustomWriteTarget(targetType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Neo4jPersistentEntity<?> createPersistentEntity(TypeInformation<T> typeInformation) {
        Class superclass;
        DefaultNeo4jPersistentEntity newEntity = new DefaultNeo4jPersistentEntity(typeInformation);
        String primaryLabel = newEntity.getPrimaryLabel();
        if (!newEntity.describesInterface()) {
            Neo4jPersistentEntity existingEntity;
            if (this.nodeDescriptionStore.containsKey(primaryLabel) && !(existingEntity = (Neo4jPersistentEntity)this.nodeDescriptionStore.get(primaryLabel)).getTypeInformation().getRawTypeInformation().equals((Object)typeInformation.getRawTypeInformation())) {
                String message = String.format(Locale.ENGLISH, "The schema already contains a node description under the primary label %s", primaryLabel);
                throw new MappingException(message);
            }
            if (this.nodeDescriptionStore.containsValue(newEntity)) {
                Optional<String> label = this.nodeDescriptionStore.entrySet().stream().filter(e -> ((NodeDescription)e.getValue()).equals(newEntity)).map(Map.Entry::getKey).findFirst();
                String message = String.format(Locale.ENGLISH, "The schema already contains description %s under the primary label %s", newEntity, label.orElse("n/a"));
                throw new MappingException(message);
            }
            NodeDescription<?> existingDescription = this.getNodeDescription(newEntity.getUnderlyingClass());
            if (existingDescription != null && !existingDescription.getPrimaryLabel().equals(newEntity.getPrimaryLabel())) {
                String message = String.format(Locale.ENGLISH, "The schema already contains description with the underlying class %s under the primary label %s", newEntity.getUnderlyingClass().getName(), existingDescription.getPrimaryLabel());
                throw new MappingException(message);
            }
            this.nodeDescriptionStore.put(primaryLabel, newEntity);
        }
        if (Neo4jMappingContext.isValidParentNode(superclass = typeInformation.getType().getSuperclass())) {
            Neo4jMappingContext neo4jMappingContext = this;
            synchronized (neo4jMappingContext) {
                super.setStrict(false);
                Neo4jPersistentEntity parentNodeDescription = (Neo4jPersistentEntity)this.getPersistentEntity(superclass);
                if (parentNodeDescription != null) {
                    parentNodeDescription.addChildNodeDescription(newEntity);
                    newEntity.setParentNodeDescription(parentNodeDescription);
                }
                this.setStrict(this.strict);
            }
        }
        return newEntity;
    }

    private static boolean isValidParentNode(@Nullable Class<?> parentClass) {
        if (parentClass == null || parentClass.equals(Object.class)) {
            return false;
        }
        return Modifier.isAbstract(parentClass.getModifiers()) || parentClass.isAnnotationPresent(Node.class);
    }

    protected Neo4jPersistentProperty createPersistentProperty(Property property, Neo4jPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        PersistentPropertyCharacteristics optionalCharacteristics = this.propertyCharacteristicsProvider.getOptional().flatMap(provider -> Optional.ofNullable(provider.apply(property, owner))).orElse(null);
        return new DefaultNeo4jPersistentProperty(property, (PersistentEntity<?, Neo4jPersistentProperty>)owner, this, simpleTypeHolder, optionalCharacteristics);
    }

    @Override
    @Nullable
    public NodeDescription<?> getNodeDescription(String primaryLabel) {
        return this.nodeDescriptionStore.get(primaryLabel);
    }

    @Override
    public NodeDescription<?> getNodeDescription(Class<?> underlyingClass) {
        return this.doGetPersistentEntity(underlyingClass);
    }

    @Nullable
    public Neo4jPersistentEntity<?> getPersistentEntity(TypeInformation<?> typeInformation) {
        Neo4jPersistentEntity<?> existingDescription = this.doGetPersistentEntity(typeInformation);
        if (existingDescription != null) {
            return existingDescription;
        }
        return (Neo4jPersistentEntity)super.getPersistentEntity(typeInformation);
    }

    public Optional<Neo4jPersistentEntity<?>> addPersistentEntity(TypeInformation<?> typeInformation) {
        Neo4jPersistentEntity<?> existingDescription = this.doGetPersistentEntity(typeInformation);
        if (existingDescription != null) {
            return Optional.of(existingDescription);
        }
        return super.addPersistentEntity(typeInformation);
    }

    @Nullable
    private Neo4jPersistentEntity<?> doGetPersistentEntity(TypeInformation<?> typeInformation) {
        return this.doGetPersistentEntity(typeInformation.getRawTypeInformation().getType());
    }

    @Nullable
    private Neo4jPersistentEntity<?> doGetPersistentEntity(Class<?> underlyingClass) {
        String primaryLabel;
        Neo4jPersistentEntity nodeDescription;
        if (underlyingClass.isInterface() && (nodeDescription = (Neo4jPersistentEntity)this.getNodeDescription(primaryLabel = DefaultNeo4jPersistentEntity.computePrimaryLabel(underlyingClass))) != null && underlyingClass.isAssignableFrom(nodeDescription.getUnderlyingClass())) {
            return nodeDescription;
        }
        return (Neo4jPersistentEntity)this.nodeDescriptionStore.getNodeDescription(underlyingClass);
    }

    private <T> T createBeanOrInstantiate(Class<T> t) {
        Object idGenerator = this.beanFactory == null ? BeanUtils.instantiateClass(t) : this.beanFactory.getBeanProvider(t).getIfUnique(() -> this.beanFactory.createBean(t));
        return (T)idGenerator;
    }

    @Override
    public <T extends IdGenerator<?>> T getOrCreateIdGeneratorOfType(Class<T> idGeneratorType) {
        return (T)((IdGenerator)idGeneratorType.cast(this.idGenerators.computeIfAbsent(idGeneratorType, this::createBeanOrInstantiate)));
    }

    @Override
    public <T extends IdGenerator<?>> Optional<T> getIdGenerator(String reference) {
        if (this.beanFactory == null) {
            return Optional.empty();
        }
        try {
            return Optional.of((IdGenerator)this.beanFactory.getBean(reference));
        }
        catch (NoSuchBeanDefinitionException e) {
            return Optional.empty();
        }
    }

    @Nullable
    Constructor<?> findConstructor(Class<?> clazz, Class<?> ... parameterTypes) {
        try {
            return ReflectionUtils.accessibleConstructor(clazz, (Class[])parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private <T extends Neo4jPersistentPropertyConverterFactory> T getOrCreateConverterFactoryOfType(Class<T> converterFactoryType) {
        return (T)((Neo4jPersistentPropertyConverterFactory)converterFactoryType.cast(this.converterFactories.computeIfAbsent(converterFactoryType, t -> {
            Constructor<?> optionalConstructor = this.findConstructor((Class<?>)t, BeanFactory.class, Neo4jConversionService.class);
            if (optionalConstructor != null) {
                return (Neo4jPersistentPropertyConverterFactory)t.cast(BeanUtils.instantiateClass(optionalConstructor, (Object[])new Object[]{this.beanFactory, this.conversionService}));
            }
            optionalConstructor = this.findConstructor((Class<?>)t, Neo4jConversionService.class, BeanFactory.class);
            if (optionalConstructor != null) {
                return (Neo4jPersistentPropertyConverterFactory)t.cast(BeanUtils.instantiateClass(optionalConstructor, (Object[])new Object[]{this.beanFactory, this.conversionService}));
            }
            optionalConstructor = this.findConstructor((Class<?>)t, BeanFactory.class);
            if (optionalConstructor != null) {
                return (Neo4jPersistentPropertyConverterFactory)t.cast(BeanUtils.instantiateClass(optionalConstructor, (Object[])new Object[]{this.beanFactory}));
            }
            optionalConstructor = this.findConstructor((Class<?>)t, Neo4jConversionService.class);
            if (optionalConstructor != null) {
                return (Neo4jPersistentPropertyConverterFactory)t.cast(BeanUtils.instantiateClass(optionalConstructor, (Object[])new Object[]{this.conversionService}));
            }
            return (Neo4jPersistentPropertyConverterFactory)BeanUtils.instantiateClass((Class)t);
        })));
    }

    @Nullable
    Neo4jPersistentPropertyConverter<?> getOptionalCustomConversionsFor(Neo4jPersistentProperty persistentProperty) {
        if (!persistentProperty.isAnnotationPresent(ConvertWith.class)) {
            return null;
        }
        ConvertWith convertWith = (ConvertWith)persistentProperty.getRequiredAnnotation(ConvertWith.class);
        Neo4jPersistentPropertyConverterFactory persistentPropertyConverterFactory = this.getOrCreateConverterFactoryOfType(convertWith.converterFactory());
        Neo4jPersistentPropertyConverter<?> customConverter = persistentPropertyConverterFactory.getPropertyConverterFor(persistentProperty);
        boolean forCollection = false;
        if (persistentProperty.isCollectionLike()) {
            Class converterClass;
            Method getClassOfDelegate = ReflectionUtils.findMethod(customConverter.getClass(), (String)"getClassOfDelegate");
            if (getClassOfDelegate != null) {
                ReflectionUtils.makeAccessible((Method)getClassOfDelegate);
                converterClass = (Class)ReflectionUtils.invokeMethod((Method)getClassOfDelegate, customConverter);
            } else {
                converterClass = customConverter.getClass();
            }
            Map<String, Type> typeVariableMap = GenericTypeResolver.getTypeVariableMap(converterClass).entrySet().stream().collect(Collectors.toMap(e -> ((TypeVariable)e.getKey()).getName(), Map.Entry::getValue));
            Type propertyType = null;
            if (typeVariableMap.containsKey("T")) {
                propertyType = typeVariableMap.get("T");
            } else if (typeVariableMap.containsKey("P")) {
                propertyType = typeVariableMap.get("P");
            }
            forCollection = propertyType instanceof ParameterizedType && persistentProperty.getType().equals(((ParameterizedType)propertyType).getRawType());
        }
        return new NullSafeNeo4jPersistentPropertyConverter(customConverter, persistentProperty.isComposite(), forCollection);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        this.beanFactory = applicationContext.getAutowireCapableBeanFactory();
        this.eventSupport = EventSupport.discoverCallbacks(this, (BeanFactory)this.beanFactory);
    }

    public CreateRelationshipStatementHolder createStatementForImperativeSimpleRelationshipBatch(Neo4jPersistentEntity<?> neo4jPersistentEntity, RelationshipDescription relationshipDescription, List<Object> plainRelationshipRows) {
        return this.createStatementForSingleRelationship(neo4jPersistentEntity, (DefaultRelationshipDescription)relationshipDescription, plainRelationshipRows);
    }

    public CreateRelationshipStatementHolder createStatementForImperativeRelationshipsWithPropertiesBatch(boolean isNew, Neo4jPersistentEntity<?> neo4jPersistentEntity, RelationshipDescription relationshipDescription, Object relatedValues, List<Map<String, Object>> relationshipPropertiesRows) {
        List<MappingSupport.RelationshipPropertiesWithEntityHolder> relationshipPropertyValues = ((Collection)relatedValues).stream().map(MappingSupport.RelationshipPropertiesWithEntityHolder.class::cast).collect(Collectors.toList());
        return this.createStatementForRelationshipWithPropertiesBatch(isNew, neo4jPersistentEntity, relationshipDescription, relationshipPropertyValues, relationshipPropertiesRows);
    }

    public CreateRelationshipStatementHolder createStatementForSingleRelationship(Neo4jPersistentEntity<?> neo4jPersistentEntity, RelationshipDescription relationshipContext, Object relatedValue, boolean isNewRelationship) {
        if (relationshipContext.hasRelationshipProperties()) {
            MappingSupport.RelationshipPropertiesWithEntityHolder relatedValueEntityHolder = (MappingSupport.RelationshipPropertiesWithEntityHolder)(relatedValue instanceof MappingSupport.RelationshipPropertiesWithEntityHolder ? relatedValue : (((Map.Entry)relatedValue).getValue() instanceof List ? ((List)((Map.Entry)relatedValue).getValue()).get(0) : ((Map.Entry)relatedValue).getValue()));
            String dynamicRelationshipType = null;
            if (relationshipContext.isDynamic()) {
                Neo4jPersistentProperty inverse = (Neo4jPersistentProperty)((DefaultRelationshipDescription)relationshipContext).getInverse();
                TypeInformation keyType = inverse.getTypeInformation().getRequiredComponentType();
                Object key = ((Map.Entry)relatedValue).getKey();
                dynamicRelationshipType = this.conversionService.writeValue(key, keyType, inverse.getOptionalConverter()).asString();
            }
            return this.createStatementForRelationshipWithProperties(neo4jPersistentEntity, relationshipContext, dynamicRelationshipType, relatedValueEntityHolder, isNewRelationship);
        }
        return this.createStatementForSingleRelationship(neo4jPersistentEntity, (DefaultRelationshipDescription)relationshipContext, relatedValue);
    }

    private CreateRelationshipStatementHolder createStatementForRelationshipWithProperties(Neo4jPersistentEntity<?> neo4jPersistentEntity, RelationshipDescription relationshipDescription, @Nullable String dynamicRelationshipType, MappingSupport.RelationshipPropertiesWithEntityHolder relatedValue, boolean isNewRelationship) {
        Statement relationshipCreationQuery = CypherGenerator.INSTANCE.prepareSaveOfRelationshipWithProperties(neo4jPersistentEntity, relationshipDescription, isNewRelationship, dynamicRelationshipType);
        HashMap<String, Object> propMap = new HashMap<String, Object>();
        this.getEntityConverter().write(relatedValue.getRelationshipProperties(), propMap);
        return new CreateRelationshipStatementHolder(relationshipCreationQuery, propMap);
    }

    private CreateRelationshipStatementHolder createStatementForRelationshipWithPropertiesBatch(boolean isNew, Neo4jPersistentEntity<?> neo4jPersistentEntity, RelationshipDescription relationshipDescription, List<MappingSupport.RelationshipPropertiesWithEntityHolder> relatedValues, List<Map<String, Object>> relationshipPropertiesRows) {
        Statement relationshipCreationQuery = CypherGenerator.INSTANCE.prepareUpdateOfRelationshipsWithProperties(neo4jPersistentEntity, relationshipDescription, isNew);
        ArrayList<Map<String, Object>> relationshipRows = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> relationshipPropertiesEntries = new HashMap<String, Object>();
        if (isNew) {
            for (int i2 = 0; i2 < relatedValues.size(); ++i2) {
                MappingSupport.RelationshipPropertiesWithEntityHolder relatedValue = relatedValues.get(i2);
                Map<String, Object> propMap = relationshipPropertiesRows.get(i2);
                this.getEntityConverter().write(relatedValue.getRelationshipProperties(), propMap);
                relationshipRows.add(propMap);
            }
            relationshipPropertiesEntries.put("__relationships__", relationshipRows);
        }
        return new CreateRelationshipStatementHolder(relationshipCreationQuery, relationshipPropertiesEntries);
    }

    private CreateRelationshipStatementHolder createStatementForSingleRelationship(Neo4jPersistentEntity<?> neo4jPersistentEntity, DefaultRelationshipDescription relationshipDescription, Object relatedValue) {
        String relationshipType;
        if (!relationshipDescription.isDynamic()) {
            relationshipType = null;
        } else {
            Neo4jPersistentProperty inverse = (Neo4jPersistentProperty)relationshipDescription.getInverse();
            TypeInformation keyType = inverse.getTypeInformation().getRequiredComponentType();
            Object key = ((Map.Entry)relatedValue).getKey();
            relationshipType = this.conversionService.writeValue(key, keyType, inverse.getOptionalConverter()).asString();
        }
        Statement relationshipCreationQuery = CypherGenerator.INSTANCE.prepareSaveOfRelationships(neo4jPersistentEntity, relationshipDescription, relationshipType);
        return new CreateRelationshipStatementHolder(relationshipCreationQuery, Collections.emptyMap());
    }

    public <T> T invokePostLoad(Neo4jPersistentEntity<T> entity, T instance) {
        this.getPostLoadMethods(entity).forEach(methodHolder -> methodHolder.invoke(instance));
        return instance;
    }

    Set<MethodHolder> getPostLoadMethods(Neo4jPersistentEntity<?> entity) {
        return this.postLoadMethods.computeIfAbsent(entity, Neo4jMappingContext::computePostLoadMethods);
    }

    private static Set<MethodHolder> computePostLoadMethods(Neo4jPersistentEntity<?> entity) {
        LinkedHashSet postLoadMethods = new LinkedHashSet();
        ReflectionUtils.MethodFilter isValidPostLoad = method -> {
            int modifiers = method.getModifiers();
            return !Modifier.isStatic(modifiers) && method.getParameterCount() == 0 && VOID_TYPES.contains(method.getReturnType()) && AnnotationUtils.findAnnotation((Method)method, PostLoad.class) != null;
        };
        Class underlyingClass = entity.getUnderlyingClass();
        ReflectionUtils.doWithMethods((Class)underlyingClass, method -> postLoadMethods.add(new MethodHolder(method, null)), (ReflectionUtils.MethodFilter)isValidPostLoad);
        if (KotlinDetector.isKotlinType((Class)underlyingClass)) {
            ReflectionUtils.doWithFields((Class)underlyingClass, field -> ReflectionUtils.doWithMethods(field.getType(), method -> postLoadMethods.add(new MethodHolder(method, field)), (ReflectionUtils.MethodFilter)isValidPostLoad), field -> field.isSynthetic() && field.getName().startsWith("$$delegate_"));
        }
        return Collections.unmodifiableSet(postLoadMethods);
    }

    static class MethodHolder {
        private final Method method;
        @Nullable
        private final Field delegate;

        MethodHolder(Method method, @Nullable Field delegate) {
            this.method = method;
            this.delegate = delegate;
        }

        Method getMethod() {
            return this.method;
        }

        String getName() {
            return this.method.getName();
        }

        void invoke(Object instance) {
            this.method.setAccessible(true);
            ReflectionUtils.invokeMethod((Method)this.method, (Object)MethodHolder.getInstanceOrDelegate(instance, this.delegate));
        }

        static Object getInstanceOrDelegate(Object instance, @Nullable Field delegateHolder) {
            if (delegateHolder == null) {
                return instance;
            }
            try {
                delegateHolder.setAccessible(true);
                return delegateHolder.get(instance);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Builder {
        private Neo4jConversions neo4jConversions;
        @Nullable
        private TypeSystem typeSystem;
        @Nullable
        private PersistentPropertyCharacteristicsProvider persistentPropertyCharacteristicsProvider;

        private Builder() {
            this(new Neo4jConversions(), null, null);
        }

        private Builder(Neo4jConversions neo4jConversions, @Nullable TypeSystem typeSystem, @Nullable PersistentPropertyCharacteristicsProvider persistentPropertyCharacteristicsProvider) {
            this.neo4jConversions = neo4jConversions;
            this.typeSystem = typeSystem;
            this.persistentPropertyCharacteristicsProvider = persistentPropertyCharacteristicsProvider;
        }

        public Builder withNeo4jConversions(@Nullable Neo4jConversions neo4jConversions) {
            this.neo4jConversions = neo4jConversions;
            return this;
        }

        public Builder withPersistentPropertyCharacteristicsProvider(@Nullable PersistentPropertyCharacteristicsProvider persistentPropertyCharacteristicsProvider) {
            this.persistentPropertyCharacteristicsProvider = persistentPropertyCharacteristicsProvider;
            return this;
        }

        public Builder withTypeSystem(@Nullable TypeSystem typeSystem) {
            this.typeSystem = typeSystem;
            return this;
        }

        public Neo4jMappingContext build() {
            return new Neo4jMappingContext(this);
        }
    }
}

