/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.repository.query;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.redis.core.convert.IndexResolver;
import org.springframework.data.redis.core.convert.IndexedData;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.data.redis.core.mapping.RedisPersistentProperty;
import org.springframework.data.redis.repository.query.RedisOperationChain;
import org.springframework.data.support.ExampleMatcherAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ExampleQueryMapper {
    private final Set<ExampleMatcher.StringMatcher> SUPPORTED_MATCHERS = EnumSet.of(ExampleMatcher.StringMatcher.DEFAULT, ExampleMatcher.StringMatcher.EXACT);
    private final MappingContext<RedisPersistentEntity<?>, RedisPersistentProperty> mappingContext;
    private final IndexResolver indexResolver;

    public ExampleQueryMapper(MappingContext<RedisPersistentEntity<?>, RedisPersistentProperty> mappingContext, IndexResolver indexResolver) {
        Assert.notNull(mappingContext, (String)"MappingContext must not be null");
        Assert.notNull((Object)indexResolver, (String)"IndexResolver must not be null");
        this.mappingContext = mappingContext;
        this.indexResolver = indexResolver;
    }

    public RedisOperationChain getMappedExample(Example<?> example) {
        RedisOperationChain chain = new RedisOperationChain();
        ExampleMatcherAccessor matcherAccessor = new ExampleMatcherAccessor(example.getMatcher());
        this.applyPropertySpecs("", example.getProbe(), (RedisPersistentEntity)this.mappingContext.getRequiredPersistentEntity(example.getProbeType()), matcherAccessor, example.getMatcher().getMatchMode(), chain);
        return chain;
    }

    private void applyPropertySpecs(String path, @Nullable Object probe, RedisPersistentEntity<?> persistentEntity, ExampleMatcherAccessor exampleSpecAccessor, ExampleMatcher.MatchMode matchMode, RedisOperationChain chain) {
        if (probe == null) {
            return;
        }
        PersistentPropertyAccessor propertyAccessor = persistentEntity.getPropertyAccessor(probe);
        Set<IndexedData> indexedData = this.getIndexedData(path, probe, persistentEntity);
        Set indexNames = indexedData.stream().map(IndexedData::getIndexName).distinct().collect(Collectors.toSet());
        persistentEntity.forEach(property -> {
            String propertyPath;
            if (property.isIdProperty()) {
                return;
            }
            String string = propertyPath = StringUtils.hasText((String)path) ? path + "." + property.getName() : property.getName();
            if (exampleSpecAccessor.isIgnoredPath(propertyPath) || property.isCollectionLike() || property.isMap()) {
                return;
            }
            this.applyPropertySpec(propertyPath, indexNames::contains, exampleSpecAccessor, propertyAccessor, (RedisPersistentProperty)((Object)property), matchMode, chain);
        });
    }

    private void applyPropertySpec(String path, Predicate<String> hasIndex, ExampleMatcherAccessor exampleSpecAccessor, PersistentPropertyAccessor propertyAccessor, RedisPersistentProperty property, ExampleMatcher.MatchMode matchMode, RedisOperationChain chain) {
        ExampleMatcher.StringMatcher stringMatcher = exampleSpecAccessor.getDefaultStringMatcher();
        boolean ignoreCase = exampleSpecAccessor.isIgnoreCaseEnabled();
        Object value = propertyAccessor.getProperty((PersistentProperty)property);
        if (exampleSpecAccessor.hasPropertySpecifiers()) {
            stringMatcher = exampleSpecAccessor.getStringMatcherForPath(path);
            ignoreCase = exampleSpecAccessor.isIgnoreCaseForPath(path);
        }
        if (ignoreCase) {
            throw new InvalidDataAccessApiUsageException("Redis Query-by-Example supports only case-sensitive matching.");
        }
        if (!this.SUPPORTED_MATCHERS.contains(stringMatcher)) {
            throw new InvalidDataAccessApiUsageException("Redis Query-by-Example does not support string matcher %s; Supported matchers are: %s.".formatted(stringMatcher, this.SUPPORTED_MATCHERS));
        }
        if (exampleSpecAccessor.hasPropertySpecifier(path)) {
            ExampleMatcher.PropertyValueTransformer valueTransformer = exampleSpecAccessor.getValueTransformerForPath(path);
            value = ((Optional)valueTransformer.apply(Optional.ofNullable(value))).orElse(null);
        }
        if (value == null) {
            return;
        }
        if (property.isEntity()) {
            this.applyPropertySpecs(path, value, (RedisPersistentEntity)this.mappingContext.getRequiredPersistentEntity((PersistentProperty)property), exampleSpecAccessor, matchMode, chain);
        } else if (matchMode == ExampleMatcher.MatchMode.ALL) {
            if (hasIndex.test(path)) {
                chain.sismember(path, value);
            }
        } else {
            chain.orSismember(path, value);
        }
    }

    private Set<IndexedData> getIndexedData(String path, Object probe, RedisPersistentEntity<?> persistentEntity) {
        String keySpace = persistentEntity.getKeySpace();
        return keySpace == null ? Collections.emptySet() : this.indexResolver.resolveIndexesFor(persistentEntity.getKeySpace(), path, persistentEntity.getTypeInformation(), probe);
    }
}

