/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ExpireChanges<K> {
    private final Map<K, ExpiryChangeState> changes;

    ExpireChanges(Map<K, ExpiryChangeState> changes) {
        this.changes = changes;
    }

    public static <K> ExpireChanges<K> of(List<K> fields, List<Long> states) {
        Assert.isTrue((fields.size() == states.size() ? 1 : 0) != 0, (String)"Keys and States must have the same number of elements");
        if (fields.size() == 1) {
            return new ExpireChanges<K>(Map.of(fields.iterator().next(), ExpireChanges.stateFromValue(states.iterator().next())));
        }
        LinkedHashMap target = CollectionUtils.newLinkedHashMap((int)fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            target.put(fields.get(i), ExpireChanges.stateFromValue(states.get(i)));
        }
        return new ExpireChanges(Collections.unmodifiableMap(target));
    }

    public List<ExpiryChangeState> stateChanges() {
        return List.copyOf(this.changes.values());
    }

    public ExpiryChangeState stateOf(K key) {
        return this.changes.get(key);
    }

    public boolean allOk() {
        return this.allMach(ExpiryChangeState.OK::equals);
    }

    public boolean allChanged() {
        return this.allMach(it -> ExpiryChangeState.OK.equals(it) || ExpiryChangeState.EXPIRED.equals(it));
    }

    public Set<K> ok() {
        return this.filterByState(ExpiryChangeState.OK);
    }

    public Set<K> expired() {
        return this.filterByState(ExpiryChangeState.EXPIRED);
    }

    public Set<K> missed() {
        return this.filterByState(ExpiryChangeState.DOES_NOT_EXIST);
    }

    public Set<K> skipped() {
        return this.filterByState(ExpiryChangeState.CONDITION_NOT_MET);
    }

    public boolean allMach(Predicate<ExpiryChangeState> predicate) {
        return this.changes.values().stream().allMatch(predicate);
    }

    private Set<K> filterByState(ExpiryChangeState filter) {
        return this.changes.entrySet().stream().filter(entry -> ((ExpiryChangeState)entry.getValue()).equals(filter)).map(Map.Entry::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static ExpiryChangeState stateFromValue(Number value) {
        return ExpiryChangeState.of(value);
    }

    public record ExpiryChangeState(long value) {
        public static final ExpiryChangeState DOES_NOT_EXIST = new ExpiryChangeState(-2L);
        public static final ExpiryChangeState CONDITION_NOT_MET = new ExpiryChangeState(0L);
        public static final ExpiryChangeState OK = new ExpiryChangeState(1L);
        public static final ExpiryChangeState EXPIRED = new ExpiryChangeState(2L);

        static ExpiryChangeState of(boolean value) {
            return value ? OK : CONDITION_NOT_MET;
        }

        static ExpiryChangeState of(Number value) {
            return switch (value.intValue()) {
                case -2 -> DOES_NOT_EXIST;
                case 0 -> CONDITION_NOT_MET;
                case 1 -> OK;
                case 2 -> EXPIRED;
                default -> new ExpiryChangeState(value.longValue());
            };
        }

        public boolean isOk() {
            return OK.equals(this);
        }

        public boolean isExpired() {
            return EXPIRED.equals(this);
        }

        public boolean isMissing() {
            return DOES_NOT_EXIST.equals(this);
        }

        public boolean isSkipped() {
            return CONDITION_NOT_MET.equals(this);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExpiryChangeState)) {
                return false;
            }
            ExpiryChangeState that = (ExpiryChangeState)o;
            return this.value == that.value;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

