/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.connection.ReactiveNumberCommands;
import org.springframework.data.redis.connection.ReactiveStringCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.core.ReactiveValueOperations;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultReactiveValueOperations<K, V>
implements ReactiveValueOperations<K, V> {
    private final ReactiveRedisTemplate<?, ?> template;
    private final RedisSerializationContext<K, V> serializationContext;

    DefaultReactiveValueOperations(ReactiveRedisTemplate<?, ?> template, RedisSerializationContext<K, V> serializationContext) {
        this.template = template;
        this.serializationContext = serializationContext;
    }

    @Override
    public Mono<Boolean> set(K key, V value) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createMono(stringCommands -> stringCommands.set(this.rawKey(key), this.rawValue(value)));
    }

    @Override
    public Mono<Boolean> set(K key, V value, Duration timeout) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull((Object)timeout, (String)"Duration must not be null");
        return this.createMono(stringCommands -> stringCommands.set(this.rawKey(key), this.rawValue(value), Expiration.from(timeout), RedisStringCommands.SetOption.UPSERT));
    }

    @Override
    public Mono<V> setGet(K key, V value, Duration timeout) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(value, (String)"Value must not be null");
        Assert.notNull((Object)timeout, (String)"Duration must not be null");
        return this.createMono(stringCommands -> stringCommands.setGet(this.rawKey(key), this.rawValue(value), Expiration.from(timeout), RedisStringCommands.SetOption.UPSERT)).map(this::readRequiredValue);
    }

    @Override
    public Mono<Boolean> setIfAbsent(K key, V value) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createMono(stringCommands -> stringCommands.set(this.rawKey(key), this.rawValue(value), Expiration.persistent(), RedisStringCommands.SetOption.SET_IF_ABSENT));
    }

    @Override
    public Mono<Boolean> setIfAbsent(K key, V value, Duration timeout) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull((Object)timeout, (String)"Duration must not be null");
        return this.createMono(stringCommands -> stringCommands.set(this.rawKey(key), this.rawValue(value), Expiration.from(timeout), RedisStringCommands.SetOption.SET_IF_ABSENT));
    }

    @Override
    public Mono<Boolean> setIfPresent(K key, V value) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createMono(stringCommands -> stringCommands.set(this.rawKey(key), this.rawValue(value), Expiration.persistent(), RedisStringCommands.SetOption.SET_IF_PRESENT));
    }

    @Override
    public Mono<Boolean> setIfPresent(K key, V value, Duration timeout) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull((Object)timeout, (String)"Duration must not be null");
        return this.createMono(stringCommands -> stringCommands.set(this.rawKey(key), this.rawValue(value), Expiration.from(timeout), RedisStringCommands.SetOption.SET_IF_PRESENT));
    }

    @Override
    public Mono<Boolean> multiSet(Map<? extends K, ? extends V> map) {
        Assert.notNull(map, (String)"Map must not be null");
        return this.createMono(stringCommands -> {
            Mono serializedMap = Flux.fromIterable(() -> map.entrySet().iterator()).collectMap(entry -> this.rawKey(entry.getKey()), entry -> this.rawValue(entry.getValue()));
            return serializedMap.flatMap(stringCommands::mSet);
        });
    }

    @Override
    public Mono<Boolean> multiSetIfAbsent(Map<? extends K, ? extends V> map) {
        Assert.notNull(map, (String)"Map must not be null");
        return this.createMono(stringCommands -> {
            Mono serializedMap = Flux.fromIterable(() -> map.entrySet().iterator()).collectMap(entry -> this.rawKey(entry.getKey()), entry -> this.rawValue(entry.getValue()));
            return serializedMap.flatMap(stringCommands::mSetNX);
        });
    }

    @Override
    public Mono<V> get(Object key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.createMono(stringCommands -> stringCommands.get(this.rawKey(key)).map(this::readRequiredValue));
    }

    @Override
    public Mono<V> getAndDelete(K key) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createMono(stringCommands -> stringCommands.getDel(this.rawKey(key)).map(this::readRequiredValue));
    }

    @Override
    public Mono<V> getAndExpire(K key, Duration timeout) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        return this.createMono(stringCommands -> stringCommands.getEx(this.rawKey(key), Expiration.from(timeout)).map(this::readRequiredValue));
    }

    @Override
    public Mono<V> getAndPersist(K key) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createMono(stringCommands -> stringCommands.getEx(this.rawKey(key), Expiration.persistent()).map(this::readRequiredValue));
    }

    @Override
    public Mono<V> getAndSet(K key, V value) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createMono(stringCommands -> stringCommands.getSet(this.rawKey(key), this.rawValue(value)).mapNotNull(this.value()::read));
    }

    @Override
    public Mono<List<V>> multiGet(Collection<K> keys) {
        Assert.notNull(keys, (String)"Keys must not be null");
        return this.createMono(stringCommands -> Flux.fromIterable((Iterable)keys).map(this.key()::write).collectList().flatMap(stringCommands::mGet).map(this::deserializeValues));
    }

    @Override
    public Mono<Long> increment(K key) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createNumericMono(numberCommands -> numberCommands.incr(this.rawKey(key)));
    }

    @Override
    public Mono<Long> increment(K key, long delta) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createNumericMono(numberCommands -> numberCommands.incrBy(this.rawKey(key), delta));
    }

    @Override
    public Mono<Double> increment(K key, double delta) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createNumericMono(numberCommands -> numberCommands.incrBy(this.rawKey(key), delta));
    }

    @Override
    public Mono<Long> decrement(K key) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createNumericMono(numberCommands -> numberCommands.decr(this.rawKey(key)));
    }

    @Override
    public Mono<Long> decrement(K key, long delta) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createNumericMono(numberCommands -> numberCommands.decrBy(this.rawKey(key), delta));
    }

    @Override
    public Mono<Long> append(K key, String value) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return this.createMono(stringCommands -> stringCommands.append(this.rawKey(key), this.serializationContext.getStringSerializationPair().write(value)));
    }

    @Override
    public Mono<String> get(K key, long start, long end) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createMono(stringCommands -> stringCommands.getRange(this.rawKey(key), start, end).mapNotNull(this.stringSerializationPair()::read));
    }

    @Override
    public Mono<Long> set(K key, V value, long offset) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createMono(stringCommands -> stringCommands.setRange(this.rawKey(key), this.rawValue(value), offset));
    }

    @Override
    public Mono<Long> size(K key) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createMono(stringCommands -> stringCommands.strLen(this.rawKey(key)));
    }

    @Override
    public Mono<Boolean> setBit(K key, long offset, boolean value) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createMono(stringCommands -> stringCommands.setBit(this.rawKey(key), offset, value));
    }

    @Override
    public Mono<Boolean> getBit(K key, long offset) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createMono(stringCommands -> stringCommands.getBit(this.rawKey(key), offset));
    }

    @Override
    public Mono<List<Long>> bitField(K key, BitFieldSubCommands subCommands) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull((Object)subCommands, (String)"BitFieldSubCommands must not be null");
        return this.createMono(stringCommands -> stringCommands.bitField(this.rawKey(key), subCommands));
    }

    @Override
    public Mono<Boolean> delete(K key) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.template.doCreateMono(connection -> connection.keyCommands().del(this.rawKey(key))).map(l -> l != 0L);
    }

    private <T> Mono<T> createNumericMono(Function<ReactiveNumberCommands, Publisher<T>> function) {
        Assert.notNull(function, (String)"Function must not be null");
        return this.template.doCreateMono(connection -> (Publisher)function.apply(connection.numberCommands()));
    }

    private <T> Mono<T> createMono(Function<ReactiveStringCommands, Publisher<T>> function) {
        Assert.notNull(function, (String)"Function must not be null");
        return this.template.doCreateMono(connection -> (Publisher)function.apply(connection.stringCommands()));
    }

    private ByteBuffer rawKey(K key) {
        return this.serializationContext.getKeySerializationPair().write(key);
    }

    private ByteBuffer rawValue(V value) {
        return this.serializationContext.getValueSerializationPair().write(value);
    }

    private @Nullable V readValue(ByteBuffer buffer) {
        return this.serializationContext.getValueSerializationPair().read(buffer);
    }

    private V readRequiredValue(ByteBuffer buffer) {
        V value = this.readValue(buffer);
        if (value != null) {
            return value;
        }
        throw new InvalidDataAccessApiUsageException("Deserialized value is null");
    }

    private RedisSerializationContext.SerializationPair<String> stringSerializationPair() {
        return this.serializationContext.getStringSerializationPair();
    }

    private RedisSerializationContext.SerializationPair<K> key() {
        return this.serializationContext.getKeySerializationPair();
    }

    private RedisSerializationContext.SerializationPair<V> value() {
        return this.serializationContext.getValueSerializationPair();
    }

    private List<V> deserializeValues(List<ByteBuffer> source) {
        ArrayList<V> result = new ArrayList<V>(source.size());
        for (ByteBuffer buffer : source) {
            if (buffer == null) {
                result.add(null);
                continue;
            }
            result.add(this.readValue(buffer));
        }
        return result;
    }
}

